/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log.log4j.layout;

import com.qaprosoft.zafira.log.domain.MetaInfoMessage;
import com.qaprosoft.zafira.log.log4j.level.MetaInfoLevel;
import java.util.ArrayList;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class LoggingEventBuilder {
    private final JSONObject object;

    LoggingEventBuilder(JSONObject object) {
        this.object = object;
    }

    LoggingEventBuilder writeThrowable(LoggingEvent event) throws JSONException {
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        if (throwableInformation != null) {
            Throwable t = throwableInformation.getThrowable();
            JSONObject throwable = new JSONObject();
            throwable.put("message", (Object)t.getMessage());
            throwable.put("className", (Object)t.getClass().getCanonicalName());
            ArrayList<JSONObject> traceObjects = new ArrayList<JSONObject>();
            for (StackTraceElement ste : t.getStackTrace()) {
                JSONObject element = new JSONObject();
                element.put("class", (Object)ste.getClassName());
                element.put("method", (Object)ste.getMethodName());
                element.put("line", ste.getLineNumber());
                element.put("file", (Object)ste.getFileName());
                traceObjects.add(element);
            }
            this.object.put("stackTrace", traceObjects);
            this.object.put("throwable", (Object)throwable);
        }
        return this;
    }

    LoggingEventBuilder writeBasic(LoggingEvent event) throws JSONException {
        this.object.put("threadName", (Object)event.getThreadName());
        this.object.put("level", (Object)event.getLevel().toString());
        this.object.put("timestamp", System.currentTimeMillis());
        if (event.getLevel().equals((Object)MetaInfoLevel.META_INFO)) {
            MetaInfoMessage metaInfoMessage = (MetaInfoMessage)event.getMessage();
            this.object.put("message", (Object)metaInfoMessage.getMessage());
            this.object.put("headers", (Object)new JSONObject(metaInfoMessage.getHeaders()));
        } else {
            this.object.put("message", event.getMessage());
        }
        this.object.put("logger", (Object)event.getLoggerName());
        return this;
    }

    String build() {
        return this.object.toString();
    }
}

