/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.dto.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.zafira.models.db.UserPreference;
import com.qaprosoft.zafira.models.dto.AbstractType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserType
extends AbstractType {
    @NotEmpty(message="Username required")
    @Pattern(regexp="[\\w-]+", message="Invalid format")
    private @NotEmpty(message="Username required") @Pattern(regexp="[\\w-]+", message="Invalid format") String username;
    private String email;
    private String firstName;
    private String lastName;
    private String password;
    private String photoURL;
    private List<UserPreference> preferences = new ArrayList<UserPreference>();
    private Date lastLogin;

    public UserType(String username, String email, String firstName, String lastName) {
        this.username = username;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @AssertTrue(message="Email confirmation not matching")
    @JsonIgnore
    public @AssertTrue(message="Email confirmation not matching") boolean isEmailConfirmationValid() {
        return this.email == null || new EmailValidator().isValid((CharSequence)this.email, null);
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPhotoURL() {
        return this.photoURL;
    }

    public List<UserPreference> getPreferences() {
        return this.preferences;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPhotoURL(String photoURL) {
        this.photoURL = photoURL;
    }

    public void setPreferences(List<UserPreference> preferences) {
        this.preferences = preferences;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public UserType() {
    }
}

