/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.db;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.zafira.models.db.AbstractEntity;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.TestArtifact;
import com.qaprosoft.zafira.models.db.TestConfig;
import com.qaprosoft.zafira.models.db.WorkItem;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Test
extends AbstractEntity
implements Comparable<Test> {
    private static final long serialVersionUID = -915700504693067056L;
    private String name;
    private Status status;
    private String testArgs;
    private Long testRunId;
    private Long testCaseId;
    private String testGroup;
    private String message;
    private Integer messageHashCode;
    private Date startTime;
    private Date finishTime;
    private int retry;
    private TestConfig testConfig;
    private List<WorkItem> workItems;
    private boolean knownIssue;
    private boolean blocker;
    private boolean needRerun;
    private String owner;
    private String secondaryOwner;
    private String dependsOnMethods;
    private String testClass;
    private Set<TestArtifact> artifacts = new HashSet<TestArtifact>();

    public Test() {
        this.testConfig = new TestConfig();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getTestArgs() {
        return this.testArgs;
    }

    public void setTestArgs(String testArgs) {
        this.testArgs = testArgs;
    }

    public Long getTestRunId() {
        return this.testRunId;
    }

    public void setTestRunId(Long testRunId) {
        this.testRunId = testRunId;
    }

    public Long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public String getTestGroup() {
        return this.testGroup;
    }

    public String getNotNullTestGroup() {
        return this.testGroup == null ? "n/a" : this.testGroup;
    }

    public void setTestGroup(String testGroup) {
        this.testGroup = testGroup;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    public void setTestConfig(TestConfig testConfig) {
        this.testConfig = testConfig;
    }

    public List<WorkItem> getWorkItems() {
        return this.workItems;
    }

    public WorkItem getWorkItemByType(WorkItem.Type type) {
        if (this.workItems != null) {
            for (WorkItem workItem : this.workItems) {
                if (!type.equals((Object)workItem.getType())) continue;
                return workItem;
            }
        }
        return null;
    }

    public void setWorkItems(List<WorkItem> workItems) {
        this.workItems = workItems;
    }

    public boolean isKnownIssue() {
        return this.knownIssue;
    }

    public void setKnownIssue(boolean knownIssue) {
        this.knownIssue = knownIssue;
    }

    public boolean isBlocker() {
        return this.blocker;
    }

    public void setBlocker(boolean blocker) {
        this.blocker = blocker;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getSecondaryOwner() {
        return this.secondaryOwner;
    }

    public void setSecondaryOwner(String secondaryOwner) {
        this.secondaryOwner = secondaryOwner;
    }

    public boolean isNeedRerun() {
        return this.needRerun;
    }

    public void setNeedRerun(boolean needRerun) {
        this.needRerun = needRerun;
    }

    public String getDependsOnMethods() {
        return this.dependsOnMethods;
    }

    public void setDependsOnMethods(String dependsOnMethods) {
        this.dependsOnMethods = dependsOnMethods;
    }

    public Integer getMessageHashCode() {
        return this.messageHashCode;
    }

    public void setMessageHashCode(Integer messageHashCode) {
        this.messageHashCode = messageHashCode;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public void setTestClass(String testClass) {
        this.testClass = testClass;
    }

    public Set<TestArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<TestArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    @Override
    public int compareTo(Test test) {
        if (Arrays.asList(Status.ABORTED, Status.SKIPPED, Status.FAILED).contains((Object)this.getStatus())) {
            return -1;
        }
        return 0;
    }
}

