/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.zafira.models.db.AbstractEntity;
import com.qaprosoft.zafira.models.db.Job;
import com.qaprosoft.zafira.models.db.Project;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.TestSuite;
import com.qaprosoft.zafira.models.db.User;
import com.qaprosoft.zafira.models.db.WorkItem;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Seconds;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestRun
extends AbstractEntity {
    private static final long serialVersionUID = -1847933012610222160L;
    private String ciRunId;
    private User user;
    private TestSuite testSuite;
    private Status status;
    private String scmURL;
    private String scmBranch;
    private String scmCommit;
    @JsonIgnore
    private String configXML;
    private WorkItem workItem;
    private Job job;
    private Integer buildNumber;
    private Job upstreamJob;
    private Integer upstreamJobBuildNumber;
    private Initiator startedBy;
    private Project project;
    private boolean knownIssue;
    private boolean blocker;
    private String env;
    private String platform;
    private String appVersion;
    private Date startedAt;
    private Integer elapsed;
    private Integer eta;
    private String comments;
    private DriverMode driverMode;
    private Integer passed;
    private Integer failed;
    private Integer failedAsKnown;
    private Integer failedAsBlocker;
    private Integer skipped;
    private Integer inProgress;
    private boolean reviewed;

    public boolean isReviewed() {
        return this.reviewed;
    }

    public void setReviewed(boolean reviewed) {
        this.reviewed = reviewed;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getScmURL() {
        return this.scmURL;
    }

    public void setScmURL(String scmURL) {
        this.scmURL = scmURL;
    }

    public String getScmBranch() {
        return this.scmBranch;
    }

    public void setScmBranch(String scmBranch) {
        this.scmBranch = scmBranch;
    }

    public String getScmCommit() {
        return this.scmCommit;
    }

    public void setScmCommit(String scmCommit) {
        this.scmCommit = scmCommit;
    }

    public String getConfigXML() {
        return this.configXML;
    }

    public void setConfigXML(String configXML) {
        this.configXML = configXML;
    }

    public WorkItem getWorkItem() {
        return this.workItem;
    }

    public void setWorkItem(WorkItem workItem) {
        this.workItem = workItem;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    public Job getUpstreamJob() {
        return this.upstreamJob;
    }

    public void setUpstreamJob(Job upstreamJob) {
        this.upstreamJob = upstreamJob;
    }

    public Integer getUpstreamJobBuildNumber() {
        return this.upstreamJobBuildNumber;
    }

    public void setUpstreamJobBuildNumber(Integer upstreamJobBuildNumber) {
        this.upstreamJobBuildNumber = upstreamJobBuildNumber;
    }

    public Initiator getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(Initiator startedBy) {
        this.startedBy = startedBy;
    }

    public String getCiRunId() {
        return this.ciRunId;
    }

    public void setCiRunId(String ciRunId) {
        this.ciRunId = ciRunId;
    }

    public Integer getPassed() {
        return this.passed;
    }

    public void setPassed(Integer passed) {
        this.passed = passed;
    }

    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public Integer getFailedAsKnown() {
        return this.failedAsKnown;
    }

    public void setFailedAsKnown(Integer failedAsKnown) {
        this.failedAsKnown = failedAsKnown;
    }

    public Integer getFailedAsBlocker() {
        return this.failedAsBlocker;
    }

    public void setFailedAsBlocker(Integer failedAsBlocker) {
        this.failedAsBlocker = failedAsBlocker;
    }

    public Integer getSkipped() {
        return this.skipped;
    }

    public void setSkipped(Integer skipped) {
        this.skipped = skipped;
    }

    public Integer getInProgress() {
        return this.inProgress;
    }

    public void setInProgress(Integer inProgress) {
        this.inProgress = inProgress;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean isKnownIssue() {
        return this.knownIssue;
    }

    public void setKnownIssue(boolean knownIssue) {
        this.knownIssue = knownIssue;
    }

    public boolean isBlocker() {
        return this.blocker;
    }

    public void setBlocker(boolean blocker) {
        this.blocker = blocker;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Integer getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Integer elapsed) {
        this.elapsed = elapsed;
    }

    public Integer getEta() {
        return this.eta;
    }

    public void setEta(Integer eta) {
        this.eta = eta;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public DriverMode getDriverMode() {
        return this.driverMode;
    }

    public void setDriverMode(DriverMode driverMode) {
        this.driverMode = driverMode;
    }

    public Integer getCountdown() {
        Integer countdown = null;
        if (Status.IN_PROGRESS.equals((Object)this.status) && this.startedAt != null && this.eta != null) {
            LocalDateTime from = new LocalDateTime(this.startedAt.getTime());
            LocalDateTime to = new LocalDateTime((Object)Calendar.getInstance().getTime());
            countdown = Math.max(0, this.eta - Seconds.secondsBetween((ReadablePartial)from, (ReadablePartial)to).getSeconds());
        }
        return countdown;
    }

    public static enum DriverMode {
        METHOD_MODE,
        CLASS_MODE,
        SUITE_MODE;

    }

    public static enum Initiator {
        SCHEDULER,
        UPSTREAM_JOB,
        HUMAN;

    }
}

