/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.dto.monitor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.zafira.models.db.AbstractEntity;
import com.qaprosoft.zafira.models.db.Monitor;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.quartz.CronExpression;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MonitorType
extends AbstractEntity {
    private static final long serialVersionUID = -4720099488195144150L;
    @NotNull(message="Name required")
    @Size(max=500, message="Should be less than 500")
    private String name;
    @NotNull(message="URL required")
    @Size(max=500, message="Should be less than 500")
    private String url;
    @NotNull(message="HTTP method required")
    private Monitor.HttpMethod httpMethod;
    private String requestBody;
    @Size(max=50, message="Should be less than 50")
    private String environment;
    private String comment;
    @Size(max=50, message="Should be less than 50")
    private String tag;
    @NotNull(message="Cron expression required")
    private String cronExpression;
    @NotNull(message="Type required")
    private Monitor.Type type;
    @NotNull(message="Checkbox should be enabled or disabled")
    private boolean notificationsEnabled;
    @NotNull(message="Checkbox should be enabled or disabled")
    private boolean monitorEnabled;
    @Size(max=500, message="Should be less than 500")
    private String recipients;
    @NotNull(message="Expected code required")
    @Min(value=0L, message="Should be greater than 0")
    private int expectedCode;
    private boolean success;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Monitor.HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(Monitor.HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public boolean isNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public void setNotificationsEnabled(boolean notificationsEnabled) {
        this.notificationsEnabled = notificationsEnabled;
    }

    public boolean isMonitorEnabled() {
        return this.monitorEnabled;
    }

    public void setMonitorEnabled(boolean monitorEnabled) {
        this.monitorEnabled = monitorEnabled;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public int getExpectedCode() {
        return this.expectedCode;
    }

    public void setExpectedCode(int expectedCode) {
        this.expectedCode = expectedCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Monitor.Type getType() {
        return this.type;
    }

    public void setType(Monitor.Type type) {
        this.type = type;
    }

    @AssertTrue(message="Cron expression is invalid")
    public boolean isCronExpressionValid() {
        return CronExpression.isValidExpression((String)this.cronExpression);
    }
}

