/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.core.util.BeanUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;

public class BeanSerializer
implements Serializer {
    public static final String DEFAULT_JAVADOC_SUFFIX = " is a Querydsl bean type";
    public static final boolean DEFAULT_PROPERTY_ANNOTATIONS = true;
    private static final Function<Property, Parameter> propertyToParameter = new Function<Property, Parameter>(){

        @Override
        public Parameter apply(Property input) {
            return new Parameter(input.getName(), input.getType());
        }
    };
    private final Class<? extends Annotation> generatedAnnotationClass;
    private final boolean propertyAnnotations;
    private final List<Type> interfaces = new ArrayList<Type>();
    private final String javadocSuffix;
    private boolean addToString;
    private boolean addFullConstructor;
    private boolean printSupertype = false;

    public BeanSerializer() {
        this(true, DEFAULT_JAVADOC_SUFFIX, GeneratedAnnotationResolver.resolveDefault());
    }

    public BeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    @Inject
    public BeanSerializer(@Named(value="javadocSuffix") String javadocSuffix, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        this(true, javadocSuffix, generatedAnnotationClass);
    }

    public BeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, DEFAULT_JAVADOC_SUFFIX);
    }

    public BeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this(propertyAnnotations, javadocSuffix, GeneratedAnnotationResolver.resolveDefault());
    }

    public BeanSerializer(boolean propertyAnnotations, String javadocSuffix, Class<? extends Annotation> generatedAnnotationClass) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
        this.generatedAnnotationClass = generatedAnnotationClass;
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        for (Type iface : this.interfaces) {
            importedClasses.add(iface.getFullName());
        }
        importedClasses.add(this.generatedAnnotationClass.getName());
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasCollections()) {
            importedClasses.add(Collection.class.getName());
        }
        if (model.hasSets()) {
            importedClasses.add(Set.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        if (this.addToString && model.hasArrays()) {
            importedClasses.add(Arrays.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[0]));
        writer.javadoc(simpleName + this.javadocSuffix);
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line("@", this.generatedAnnotationClass.getSimpleName(), "(\"", this.getClass().getName(), "\")");
        if (!this.interfaces.isEmpty()) {
            Type superType = null;
            if (this.printSupertype && model.getSuperType() != null) {
                superType = model.getSuperType().getType();
            }
            Type[] ifaces = this.interfaces.toArray(new Type[0]);
            writer.beginClass(model, superType, ifaces);
        } else if (this.printSupertype && model.getSuperType() != null) {
            writer.beginClass(model, model.getSuperType().getType(), new Type[0]);
        } else {
            writer.beginClass(model);
        }
        this.bodyStart(model, writer);
        if (this.addFullConstructor) {
            this.addFullConstructor(model, writer);
        }
        for (Property property : model.getProperties()) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + BeanUtils.capitalize(propertyName), new Parameter[0]);
            writer.line("return ", propertyName, ";");
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + BeanUtils.capitalize(propertyName), parameter);
            writer.line("this.", propertyName, " = ", propertyName, ";");
            writer.end();
        }
        if (this.addToString) {
            this.addToString(model, writer);
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void addFullConstructor(EntityType model, CodeWriter writer) throws IOException {
        writer.beginConstructor(new Parameter[0]);
        writer.end();
        writer.beginConstructor(model.getProperties(), propertyToParameter::apply);
        for (Property property : model.getProperties()) {
            writer.line("this.", property.getEscapedName(), " = ", property.getEscapedName(), ";");
        }
        writer.end();
    }

    protected void addToString(EntityType model, CodeWriter writer) throws IOException {
        writer.line("@Override");
        writer.beginPublicMethod((Type)Types.STRING, "toString", new Parameter[0]);
        StringBuilder builder = new StringBuilder();
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            if (builder.length() > 0) {
                builder.append(" + \", ");
            } else {
                builder.append("\"");
            }
            builder.append(propertyName).append(" = \" + ");
            if (property.getType().getCategory() == TypeCategory.ARRAY) {
                builder.append("Arrays.toString(").append(propertyName).append(")");
                continue;
            }
            builder.append(propertyName);
        }
        writer.line(" return ", builder.toString(), ";");
        writer.end();
    }

    protected void bodyStart(EntityType model, CodeWriter writer) throws IOException {
    }

    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }

    public void addInterface(Class<?> iface) {
        this.interfaces.add(new ClassType(iface, new Type[0]));
    }

    public void addInterface(Type type) {
        this.interfaces.add(type);
    }

    public void setAddToString(boolean addToString) {
        this.addToString = addToString;
    }

    public void setAddFullConstructor(boolean addFullConstructor) {
        this.addFullConstructor = addFullConstructor;
    }

    public void setPrintSupertype(boolean printSupertype) {
        this.printSupertype = printSupertype;
    }
}

