/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.AnnotationHelper;
import com.querydsl.codegen.DefaultVariableNameFunction;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.ParameterizedTypeImpl;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.TypeExtends;
import com.querydsl.codegen.utils.model.TypeSuper;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.core.util.PrimitiveUtils;
import com.querydsl.core.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class TypeFactory {
    private static final Type ANY = new TypeExtends(Types.OBJECT);
    private final Map<List<?>, Type> cache = new HashMap();
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final List<AnnotationHelper> annotationHelpers = new ArrayList<AnnotationHelper>();
    private final Set<Class<?>> embeddableTypes = new HashSet();
    private boolean unknownAsEntity = false;
    private Function<EntityType, String> variableNameFunction;

    public TypeFactory() {
        this(new ArrayList<Class<? extends Annotation>>(), DefaultVariableNameFunction.INSTANCE);
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this(entityAnnotations, DefaultVariableNameFunction.INSTANCE);
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations, Function<EntityType, String> variableNameFunction) {
        this.entityAnnotations = entityAnnotations;
        this.variableNameFunction = variableNameFunction;
    }

    public EntityType getEntityType(Class<?> cl) {
        java.lang.reflect.Type generic = cl;
        if (cl.getTypeParameters().length > 0) {
            generic = new ParameterizedTypeImpl(cl, cl.getTypeParameters());
        }
        return (EntityType)this.get(true, cl, null, generic);
    }

    public Type get(Class<?> cl) {
        return this.get(cl, cl);
    }

    public Type get(Class<?> cl, java.lang.reflect.Type genericType) {
        return this.get(this.isEntityClass(cl), cl, null, genericType);
    }

    public Type get(Class<?> cl, AnnotatedElement annotated, java.lang.reflect.Type genericType) {
        return this.get(this.isEntityClass(cl), cl, annotated, genericType);
    }

    public Type get(boolean entity, Class<?> cl, java.lang.reflect.Type genericType) {
        return this.get(entity, cl, null, genericType);
    }

    public Type get(boolean entity, Class<?> cl, AnnotatedElement annotated, java.lang.reflect.Type genericType) {
        Type value;
        List<Object> key = new ArrayList<java.lang.reflect.Type>();
        key.add(genericType);
        AnnotationHelper annotationHelper = null;
        Annotation selectedAnnotation = null;
        if (annotated != null) {
            block0: for (Annotation annotation : annotated.getDeclaredAnnotations()) {
                for (AnnotationHelper helper : this.annotationHelpers) {
                    if (!helper.isSupported(annotation.annotationType())) continue;
                    key.add(annotation.annotationType());
                    selectedAnnotation = annotated.getAnnotation(annotation.annotationType());
                    annotationHelper = helper;
                    key.add(helper.getCustomKey(selectedAnnotation));
                    continue block0;
                }
            }
        }
        if (this.cache.containsKey(key = Collections.unmodifiableList(key))) {
            value = this.cache.get(key);
            if (entity && !(value instanceof EntityType)) {
                value = new EntityType(value, this.variableNameFunction);
                this.cache.put(key, value);
            }
            return value;
        }
        value = this.create(entity, cl, annotationHelper, selectedAnnotation, genericType, key);
        this.cache.put(key, value);
        return value;
    }

    private Type create(boolean entity, Class<?> cl, AnnotationHelper annotationHelper, Annotation annotation, java.lang.reflect.Type genericType, List<?> key) {
        Type value;
        if (cl.isPrimitive()) {
            cl = PrimitiveUtils.wrap(cl);
        }
        Type[] tempParams = (Type[])Array.newInstance(Type.class, ReflectionUtils.getTypeParameterCount(genericType));
        this.cache.put(key, new ClassType(cl, tempParams));
        Type[] parameters = this.getParameters(cl, genericType);
        if (cl.isArray()) {
            Type componentType = this.get(cl.getComponentType());
            if (cl.getComponentType().isPrimitive()) {
                componentType = Types.PRIMITIVES.get(componentType);
            }
            value = componentType.asArrayType();
        } else {
            value = cl.isEnum() ? new ClassType(TypeCategory.ENUM, cl, new Type[0]) : (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl) ? new ClassType(TypeCategory.NUMERIC, cl, parameters) : (entity ? this.createOther(cl, entity, annotationHelper, annotation, parameters) : (Map.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.MAP, parameters[0], this.asGeneric(parameters[1])) : (List.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.LIST, this.asGeneric(parameters[0])) : (Set.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.SET, this.asGeneric(parameters[0])) : (Collection.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.COLLECTION, this.asGeneric(parameters[0])) : this.createOther(cl, entity, annotationHelper, annotation, parameters)))))));
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            value = tv.getBounds().length == 1 && tv.getBounds()[0].equals(Object.class) ? new TypeSuper(tv.getName(), value) : new TypeExtends(tv.getName(), value);
        }
        if (entity && !(value instanceof EntityType)) {
            value = new EntityType(value, this.variableNameFunction);
        }
        return value;
    }

    private Type asGeneric(Type type) {
        int count;
        if (type.getParameters().size() == 0 && (count = type.getJavaClass().getTypeParameters().length) > 0) {
            return new SimpleType(type, new Type[count]);
        }
        return type;
    }

    private Type createOther(Class<?> cl, boolean entity, AnnotationHelper annotationHelper, Annotation annotation, Type[] parameters) {
        TypeCategory typeCategory = TypeCategory.get(cl.getName());
        if (annotationHelper != null) {
            typeCategory = annotationHelper.getTypeByAnnotation(cl, annotation);
        } else if (this.embeddableTypes.contains(cl)) {
            typeCategory = TypeCategory.CUSTOM;
        } else if (this.unknownAsEntity && typeCategory == TypeCategory.SIMPLE && !cl.getName().startsWith("java")) {
            typeCategory = TypeCategory.CUSTOM;
        } else if (typeCategory == TypeCategory.SIMPLE && entity) {
            typeCategory = TypeCategory.ENTITY;
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl) && !cl.equals(Comparable.class)) {
            typeCategory = TypeCategory.COMPARABLE;
        }
        return new ClassType(typeCategory, cl, parameters);
    }

    private Type[] getParameters(Class<?> cl, java.lang.reflect.Type genericType) {
        int parameterCount = ReflectionUtils.getTypeParameterCount(genericType);
        if (parameterCount > 0) {
            return this.getGenericParameters(cl, genericType, parameterCount);
        }
        if (Map.class.isAssignableFrom(cl)) {
            return new Type[]{Types.OBJECT, Types.OBJECT};
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return new Type[]{Types.OBJECT};
        }
        return new Type[0];
    }

    private Type[] getGenericParameters(Class<?> cl, java.lang.reflect.Type genericType, int parameterCount) {
        Type[] types = new Type[parameterCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getGenericParameter(cl, genericType, i);
        }
        return types;
    }

    private Type getGenericParameter(Class<?> cl, java.lang.reflect.Type genericType, int i) {
        java.lang.reflect.Type parameter = ReflectionUtils.getTypeParameter(genericType, i);
        if (parameter instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)parameter;
            Type rv = this.get(ReflectionUtils.getTypeParameterAsClass(genericType, i), null, parameter);
            return new TypeExtends(variable.getName(), rv);
        }
        if (parameter instanceof WildcardType && ((WildcardType)parameter).getUpperBounds()[0].equals(Object.class) && ((WildcardType)parameter).getLowerBounds().length == 0) {
            return ANY;
        }
        Type rv = this.get(ReflectionUtils.getTypeParameterAsClass(genericType, i), null, parameter);
        if (parameter instanceof WildcardType) {
            rv = new TypeExtends(rv);
        }
        return rv;
    }

    private boolean isEntityClass(Class<?> cl) {
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (!cl.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return this.embeddableTypes.contains(cl);
    }

    public void extendTypes() {
        for (Map.Entry<List<?>, Type> entry : this.cache.entrySet()) {
            EntityType entityType;
            if (!(entry.getValue() instanceof EntityType) || !(entityType = (EntityType)entry.getValue()).getProperties().isEmpty()) continue;
            for (Type type : this.cache.values()) {
                if (!type.getFullName().equals(entityType.getFullName()) || !(type instanceof EntityType)) continue;
                EntityType base = (EntityType)type;
                for (Property property : base.getProperties()) {
                    entityType.addProperty(property);
                }
            }
        }
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.unknownAsEntity = unknownAsEntity;
    }

    public void addEmbeddableType(Class<?> cl) {
        this.embeddableTypes.add(cl);
    }

    public void addAnnotationHelper(AnnotationHelper annotationHelper) {
        this.annotationHelpers.add(annotationHelper);
    }
}

