/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeExtends;
import com.querydsl.codegen.utils.model.TypeSuper;
import java.util.Objects;

final class TypeResolver {
    public static Type resolve(Type type, Type declaringType, EntityType context) {
        Type resolved = TypeResolver.unwrap(type);
        String varName = TypeResolver.getVarName(resolved);
        if (varName != null) {
            resolved = TypeResolver.resolveVar(resolved, varName, declaringType, context);
        } else if (!resolved.getParameters().isEmpty()) {
            resolved = TypeResolver.resolveWithParameters(resolved, declaringType, context);
        }
        if (type instanceof EntityType) {
            resolved = !TypeResolver.unwrap(type).equals(resolved) ? new EntityType(resolved, ((EntityType)type).getSuperTypes()) : type;
        }
        return resolved;
    }

    private static Type resolveVar(Type resolved, String varName, Type declaringType, EntityType context) {
        int index = -1;
        for (int i = 0; i < declaringType.getParameters().size(); ++i) {
            Type param = TypeResolver.unwrap(declaringType.getParameters().get(i));
            if (!Objects.equals(TypeResolver.getVarName(param), varName)) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalStateException("Did not find type " + varName + " in " + declaringType + " for " + context);
        }
        Supertype type = context.getSuperType();
        while (!type.getEntityType().equals(declaringType)) {
            type = type.getEntityType().getSuperType();
        }
        if (!type.getType().getParameters().isEmpty()) {
            return type.getType().getParameters().get(index);
        }
        return resolved;
    }

    private static Type resolveWithParameters(Type type, Type declaringType, EntityType context) {
        Type[] params = new Type[type.getParameters().size()];
        boolean transformed = false;
        for (int i = 0; i < type.getParameters().size(); ++i) {
            Type param = type.getParameters().get(i);
            if (param == null || param.getFullName().equals(type.getFullName())) continue;
            params[i] = TypeResolver.resolve(param, declaringType, context);
            if (params[i].equals(param)) continue;
            transformed = true;
        }
        if (transformed) {
            return new SimpleType(type, params);
        }
        return type;
    }

    private static String getVarName(Type type) {
        if (type instanceof TypeExtends) {
            return ((TypeExtends)type).getVarName();
        }
        if (type instanceof TypeSuper) {
            return ((TypeSuper)type).getVarName();
        }
        return null;
    }

    private static Type unwrap(Type type) {
        if (type instanceof EntityType) {
            return ((EntityType)type).getInnerType();
        }
        return type;
    }

    private TypeResolver() {
    }
}

