/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.support.ConstantHidingExpression;
import com.querydsl.core.support.EnumConversion;
import com.querydsl.core.support.NumberConversion;
import com.querydsl.core.support.NumberConversions;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLOps;
import java.util.ArrayList;
import javax.persistence.Entity;

public final class Conversions {
    public static <RT> Expression<RT> convert(Expression<RT> expr) {
        if (expr instanceof FactoryExpression) {
            FactoryExpression factoryExpr = (FactoryExpression)expr;
            for (Expression<?> e : factoryExpr.getArgs()) {
                if (!Conversions.needsConstantRemoval(e)) continue;
                return Conversions.convert(new ConstantHidingExpression(factoryExpr));
            }
            for (Expression<?> e : factoryExpr.getArgs()) {
                if (!Conversions.needsNumberConversion(e)) continue;
                return new NumberConversions(factoryExpr);
            }
        } else if (Conversions.needsNumberConversion(expr)) {
            return new NumberConversion<RT>(expr);
        }
        return expr;
    }

    private static boolean needsConstantRemoval(Expression<?> expr) {
        return (expr = ExpressionUtils.extract(expr)) instanceof Constant || expr.equals(Expressions.TRUE) || expr.equals(Expressions.FALSE) || expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS && Conversions.needsConstantRemoval(((Operation)expr).getArg(0));
    }

    private static boolean needsNumberConversion(Expression<?> expr) {
        return Number.class.isAssignableFrom((expr = ExpressionUtils.extract(expr)).getType()) && !Path.class.isInstance(expr);
    }

    private static boolean isEntityPathAndNeedsWrapping(Expression<?> expr) {
        Path path;
        return (expr instanceof Path && expr.getType().isAnnotationPresent(Entity.class) || expr instanceof EntityPath && !RelationalPath.class.isInstance(expr)) && (path = (Path)expr).getMetadata().getParent() == null;
    }

    private static <RT> FactoryExpression<RT> createEntityPathConversions(FactoryExpression<RT> factoryExpr) {
        ArrayList conversions = new ArrayList();
        for (Expression<?> e : factoryExpr.getArgs()) {
            if (Conversions.isEntityPathAndNeedsWrapping(e)) {
                conversions.add(ExpressionUtils.operation(e.getType(), (Operator)SQLOps.ALL, e));
                continue;
            }
            conversions.add(e);
        }
        return FactoryExpressionUtils.wrap(factoryExpr, conversions);
    }

    public static <RT> Expression<RT> convertForNativeQuery(Expression<RT> expr) {
        if (Conversions.isEntityPathAndNeedsWrapping(expr)) {
            return ExpressionUtils.operation(expr.getType(), (Operator)SQLOps.ALL, expr);
        }
        if (Number.class.isAssignableFrom(expr.getType())) {
            return new NumberConversion<RT>(expr);
        }
        if (Enum.class.isAssignableFrom(expr.getType())) {
            return new EnumConversion<RT>(expr);
        }
        if (expr instanceof FactoryExpression) {
            FactoryExpression<RT> factoryExpr = (FactoryExpression<RT>)expr;
            boolean numberConversions = false;
            boolean hasEntityPath = false;
            for (Expression<?> e : factoryExpr.getArgs()) {
                if (Conversions.isEntityPathAndNeedsWrapping(e)) {
                    hasEntityPath = true;
                    continue;
                }
                if (Number.class.isAssignableFrom(e.getType())) {
                    numberConversions = true;
                    continue;
                }
                if (!Enum.class.isAssignableFrom(e.getType())) continue;
                numberConversions = true;
            }
            if (hasEntityPath) {
                factoryExpr = Conversions.createEntityPathConversions(factoryExpr);
            }
            if (numberConversions) {
                factoryExpr = new NumberConversions<RT>(factoryExpr);
            }
            return factoryExpr;
        }
        return expr;
    }

    private Conversions() {
    }
}

