/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.FactoryExpressionTransformer;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.ScrollableResultsIterator;
import com.querydsl.jpa.TransformingIterator;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.jetbrains.annotations.Nullable;

public class HibernateHandler
implements QueryHandler {
    @Override
    public void addEntity(Query query, String alias, Class<?> type) {
        ((NativeQuery)query.unwrap(NativeQuery.class)).addEntity(alias, type);
    }

    @Override
    public void addScalar(Query query, String alias, Class<?> type) {
        ((NativeQuery)query.unwrap(NativeQuery.class)).addScalar(alias);
    }

    @Override
    public boolean createNativeQueryTyped() {
        return false;
    }

    @Override
    public <T> CloseableIterator<T> iterate(Query query, FactoryExpression<?> projection) {
        try {
            org.hibernate.query.Query unwrappedQuery = (org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class);
            ScrollableResults results = unwrappedQuery.scroll(ScrollMode.FORWARD_ONLY);
            CloseableIterator iterator = new ScrollableResultsIterator(results);
            if (projection != null) {
                iterator = new TransformingIterator(iterator, projection);
            }
            return iterator;
        }
        catch (PersistenceException e) {
            Iterator iterator = query.getResultList().iterator();
            if (projection != null) {
                return new TransformingIterator(iterator, projection);
            }
            return new IteratorAdapter(iterator);
        }
    }

    @Override
    public <T> Stream<T> stream(Query query, @Nullable FactoryExpression<?> projection) {
        Stream resultStream = query.getResultStream();
        if (projection != null) {
            return resultStream.map(element -> {
                Object[] objectArray;
                if (element.getClass().isArray()) {
                    objectArray = element;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = element;
                }
                return projection.newInstance(objectArray);
            });
        }
        return resultStream;
    }

    @Override
    public boolean transform(Query query, FactoryExpression<?> projection) {
        try {
            FactoryExpressionTransformer transformer = new FactoryExpressionTransformer(projection);
            ((org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class)).setResultTransformer((ResultTransformer)transformer);
            return true;
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    @Override
    public boolean wrapEntityProjections() {
        return true;
    }
}

