/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.CollectionAnyVisitor;
import com.querydsl.core.support.Context;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpressionImpl;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.JPAQueryMixin;
import javax.persistence.Entity;

class JPACollectionAnyVisitor
extends CollectionAnyVisitor {
    JPACollectionAnyVisitor() {
    }

    @Override
    protected Predicate exists(Context c, Predicate condition) {
        JPAQueryMixin query = new JPAQueryMixin();
        query.setProjection(Expressions.ONE);
        for (int i = 0; i < c.paths.size(); ++i) {
            Path<?> child = c.paths.get(i).getMetadata().getParent();
            EntityPath<?> replacement = c.replacements.get(i);
            if (c.paths.get(i).getType().isAnnotationPresent(Entity.class)) {
                query.addJoin(i == 0 ? JoinType.DEFAULT : JoinType.INNERJOIN, Expressions.as(Expressions.listPath(c.paths.get(i).getType(), SimplePath.class, child.getMetadata()), replacement));
                continue;
            }
            Path<?> parent = child.getMetadata().getParent();
            EntityPathBase newParent = new EntityPathBase(parent.getType(), ExpressionUtils.createRootVariable(parent, Math.abs(condition.hashCode())));
            EntityPathBase newChild = new EntityPathBase(child.getType(), PathMetadataFactory.forProperty(newParent, child.getMetadata().getName()));
            query.from((Expression<?>)newParent);
            query.addJoin(JoinType.INNERJOIN, Expressions.as(newChild, replacement));
            query.where(ExpressionUtils.eq(newParent, parent));
        }
        c.clear();
        query.where(condition);
        return ExpressionUtils.predicate((Operator)Ops.EXISTS, this.asExpression(query.getMetadata()));
    }

    private Expression<?> asExpression(QueryMetadata metadata) {
        return new SubQueryExpressionImpl(metadata.getProjection().getType(), metadata);
    }
}

