/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLOps;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class JPAListAccessVisitor
extends ReplaceVisitor<Void> {
    private final QueryMetadata metadata;
    private final Map<Expression<?>, Path<?>> aliases;
    private final Map<Path<?>, Path<?>> replacements = new HashMap();

    JPAListAccessVisitor(QueryMetadata metadata, Map<Expression<?>, Path<?>> aliases) {
        this.metadata = metadata;
        this.aliases = aliases;
    }

    @Override
    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, (Object)null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.LISTVALUE || pathMetadata.getPathType() == PathType.LISTVALUE_CONSTANT) {
            Path<Object> replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path<?> parent = this.shorten(pathMetadata.getParent(), true);
                replacement = ExpressionUtils.path(expr.getType(), ExpressionUtils.createRootVariable(parent, this.replacements.size()));
                this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as(parent, replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq(Expressions.operation(Integer.class, JPQLOps.INDEX, replacement), ExpressionUtils.toExpression(pathMetadata.getElement())));
                this.replacements.put(expr, replacement);
            }
            return replacement;
        }
        return super.visit(expr, (Object)context);
    }

    private Path<?> shorten(Path<?> path, boolean outer) {
        if (this.aliases.containsKey(path)) {
            return this.aliases.get(path);
        }
        if (path.getMetadata().isRoot()) {
            return path;
        }
        if (path.getMetadata().getParent().getMetadata().isRoot() && outer) {
            return path;
        }
        Class<?> type = JPAQueryMixin.getElementTypeOrType(path);
        Path<?> parent = this.shorten(path.getMetadata().getParent(), false);
        Path oldPath = ExpressionUtils.path(path.getType(), new PathMetadata(parent, path.getMetadata().getElement(), path.getMetadata().getPathType()));
        if (oldPath.getMetadata().getParent().getMetadata().isRoot() && outer) {
            return oldPath;
        }
        Path<?> newPath = ExpressionUtils.path(type, ExpressionUtils.createRootVariable(oldPath));
        this.aliases.put(path, newPath);
        this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as(oldPath, newPath));
        return newPath;
    }
}

