/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.ParameterizedExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLOps;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class JPAMapAccessVisitor
extends ReplaceVisitor<Void> {
    private final QueryMetadata metadata;
    private final Map<Expression<?>, Path<?>> aliases;
    private final Map<Path<?>, Path<?>> replacements = new HashMap();

    JPAMapAccessVisitor(QueryMetadata metadata, Map<Expression<?>, Path<?>> aliases) {
        this.metadata = metadata;
        this.aliases = aliases;
    }

    @Override
    public Expression<?> visit(Operation<?> expr, @Nullable Void context) {
        if (expr.getOperator() == Ops.CONTAINS_KEY) {
            ParameterizedExpression map = (ParameterizedExpression)expr.getArg(0);
            Expression<?> key = expr.getArg(1);
            Path<?> replacement = ExpressionUtils.path(map.getParameter(1), ExpressionUtils.createRootVariable((Path)((Object)map), Math.abs(expr.hashCode())));
            this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as(map, replacement));
            this.metadata.addJoinCondition(ExpressionUtils.eq(Expressions.operation(map.getParameter(0), JPQLOps.KEY, replacement), key));
            return ExpressionUtils.isNotNull(replacement);
        }
        if (expr.getOperator() == Ops.CONTAINS_VALUE) {
            ParameterizedExpression map = (ParameterizedExpression)expr.getArg(0);
            Expression<?> value = expr.getArg(1);
            return Expressions.predicate(JPQLOps.MEMBER_OF, value, map);
        }
        return super.visit((Operation)expr, (Object)context);
    }

    @Override
    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, (Object)null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.MAPVALUE || pathMetadata.getPathType() == PathType.MAPVALUE_CONSTANT) {
            Path<?> replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path<?> parent = this.shorten(pathMetadata.getParent(), true);
                ParameterizedExpression parExpr = (ParameterizedExpression)((Object)pathMetadata.getParent());
                replacement = ExpressionUtils.path(parExpr.getParameter(1), ExpressionUtils.createRootVariable(parent, this.replacements.size()));
                this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as(parent, replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq(Expressions.operation(parExpr.getParameter(0), JPQLOps.KEY, replacement), ExpressionUtils.toExpression(pathMetadata.getElement())));
                this.replacements.put(expr, replacement);
            }
            return replacement;
        }
        return super.visit(expr, (Object)context);
    }

    private Path<?> shorten(Path<?> path, boolean outer) {
        if (this.aliases.containsKey(path)) {
            return this.aliases.get(path);
        }
        if (path.getMetadata().isRoot()) {
            return path;
        }
        if (path.getMetadata().getParent().getMetadata().isRoot() && outer) {
            return path;
        }
        Class<?> type = JPAQueryMixin.getElementTypeOrType(path);
        Path<?> parent = this.shorten(path.getMetadata().getParent(), false);
        Path oldPath = ExpressionUtils.path(path.getType(), new PathMetadata(parent, path.getMetadata().getElement(), path.getMetadata().getPathType()));
        if (oldPath.getMetadata().getParent().getMetadata().isRoot() && outer) {
            return oldPath;
        }
        Path<?> newPath = ExpressionUtils.path(type, ExpressionUtils.createRootVariable(oldPath));
        this.aliases.put(path, newPath);
        this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as(oldPath, newPath));
        return newPath;
    }
}

