/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;

public final class NativeSQLSerializer
extends SQLSerializer {
    private final Map<Expression<?>, List<String>> aliases = new HashMap();
    private final boolean wrapEntityProjections;

    public NativeSQLSerializer(Configuration configuration) {
        this(configuration, false);
    }

    public NativeSQLSerializer(Configuration configuration, boolean wrapEntityProjections) {
        super(configuration);
        this.wrapEntityProjections = wrapEntityProjections;
    }

    protected void appendAsColumnName(Path<?> path, boolean precededByDot) {
        if (path.getAnnotatedElement().isAnnotationPresent(Column.class)) {
            Column column = path.getAnnotatedElement().getAnnotation(Column.class);
            if (!column.name().isEmpty()) {
                this.append(this.getTemplates().quoteIdentifier(column.name(), precededByDot));
            } else {
                super.appendAsColumnName(path, precededByDot);
            }
        } else {
            super.appendAsColumnName(path, precededByDot);
        }
    }

    protected void handleJoinTarget(JoinExpression je) {
        SQLTemplates templates = this.getTemplates();
        Class<?> type = je.getTarget().getType();
        if (type.isAnnotationPresent(Table.class) && templates.isSupportsAlias()) {
            boolean precededByDot;
            Table table = type.getAnnotation(Table.class);
            if (!table.schema().isEmpty() && templates.isPrintSchema()) {
                this.appendSchemaName(table.schema());
                this.append(".");
                precededByDot = true;
            } else {
                precededByDot = false;
            }
            this.appendTableName(table.name(), precededByDot);
            this.append(templates.getTableAlias());
        }
        super.handleJoinTarget(je);
    }

    private boolean isAlias(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS;
    }

    public Map<Expression<?>, List<String>> getAliases() {
        return this.aliases;
    }

    private boolean isAllExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getOperator() == SQLOps.ALL;
        }
        if (expr instanceof TemplateExpression) {
            return ((TemplateExpression)expr).getTemplate().toString().equals("*");
        }
        return false;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        boolean modified = false;
        HashSet<String> used = new HashSet<String>();
        Expression<Tuple> projection = metadata.getProjection();
        if (projection instanceof Path) {
            Path path = (Path)projection;
            if (!used.add(path.getMetadata().getName())) {
                String alias = "col_1";
                this.aliases.computeIfAbsent(projection, NativeSQLSerializer::createArrayList).add(alias);
                projection = ExpressionUtils.as(projection, alias);
                modified = true;
            } else if (path.getAnnotatedElement().isAnnotationPresent(Column.class)) {
                Column column = path.getAnnotatedElement().getAnnotation(Column.class);
                if (!column.name().isEmpty()) {
                    this.aliases.computeIfAbsent(projection, NativeSQLSerializer::createArrayList).add(column.name());
                } else {
                    this.aliases.computeIfAbsent(projection, NativeSQLSerializer::createArrayList).add(ColumnMetadata.getName((Path)path));
                }
            } else {
                this.aliases.computeIfAbsent(projection, NativeSQLSerializer::createArrayList).add(ColumnMetadata.getName((Path)path));
            }
        } else if (projection instanceof FactoryExpression) {
            FactoryExpression factoryExpr = projection;
            ArrayList fargs = new ArrayList(factoryExpr.getArgs());
            for (int j = 0; j < fargs.size(); ++j) {
                if (fargs.get(j) instanceof Path) {
                    Column column;
                    Path path = (Path)fargs.get(j);
                    String columnName = path.getAnnotatedElement().isAnnotationPresent(Column.class) ? (!(column = path.getAnnotatedElement().getAnnotation(Column.class)).name().isEmpty() ? column.name() : ColumnMetadata.getName((Path)path)) : ColumnMetadata.getName((Path)path);
                    if (!used.add(columnName)) {
                        String alias = "col_" + (j + 1);
                        this.aliases.computeIfAbsent(path, NativeSQLSerializer::createArrayList).add(alias);
                        fargs.set(j, ExpressionUtils.as((Expression)fargs.get(j), alias));
                        continue;
                    }
                    this.aliases.computeIfAbsent(path, NativeSQLSerializer::createArrayList).add(columnName);
                    continue;
                }
                if (this.isAlias((Expression)fargs.get(j))) {
                    Operation operation = (Operation)fargs.get(j);
                    this.aliases.computeIfAbsent(operation, NativeSQLSerializer::createArrayList).add(operation.getArg(1).toString());
                    continue;
                }
                if (this.isAllExpression((Expression)fargs.get(j))) continue;
                String alias = "col_" + (j + 1);
                this.aliases.computeIfAbsent((Expression)fargs.get(j), NativeSQLSerializer::createArrayList).add(alias);
                fargs.set(j, ExpressionUtils.as((Expression)fargs.get(j), alias));
            }
            projection = Projections.tuple(new ArrayList(fargs));
            modified = true;
        } else if (this.isAlias(projection)) {
            Operation operation = (Operation)projection;
            this.aliases.computeIfAbsent(operation, NativeSQLSerializer::createArrayList).add(operation.getArg(1).toString());
        } else if (!this.isAllExpression(projection)) {
            String alias = "col_1";
            this.aliases.computeIfAbsent(projection, NativeSQLSerializer::createArrayList).add(alias);
            projection = ExpressionUtils.as(projection, alias);
            modified = true;
        }
        if (modified) {
            metadata = metadata.clone();
            metadata.setProjection(projection);
        }
        super.serialize(metadata, forCountRow);
    }

    private static <T> ArrayList<T> createArrayList(Object key) {
        return new ArrayList();
    }

    public void visitConstant(Object constant) {
        if (constant instanceof Collection) {
            this.append("(");
            boolean first = true;
            for (Object element : (Collection)constant) {
                if (!first) {
                    this.append(", ");
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(")");
        } else {
            super.visitConstant(constant);
        }
    }

    protected void serializeConstant(int parameterIndex, String constantLabel) {
        this.append("?");
        this.append(Integer.toString(parameterIndex));
    }

    protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        if (operator == SQLOps.ALL && !(args.get(0) instanceof RelationalPath) && this.wrapEntityProjections) {
            this.append("{");
            super.visitOperation(type, operator, args);
            this.append("}");
        } else {
            super.visitOperation(type, operator, args);
        }
    }
}

