/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.JoinType;
import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.hibernate.DefaultSessionHolder;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.jpa.hibernate.SessionHolder;
import com.querydsl.jpa.hibernate.StatelessSessionHolder;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.Query;

public class HibernateDeleteClause
implements DeleteClause<HibernateDeleteClause> {
    private final QueryMixin<?> queryMixin = new JPAQueryMixin();
    private final SessionHolder session;
    private final JPQLTemplates templates;
    private final Map<Path<?>, LockMode> lockModes = new HashMap();

    public HibernateDeleteClause(Session session, EntityPath<?> entity) {
        this(new DefaultSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateDeleteClause(StatelessSession session, EntityPath<?> entity) {
        this(new StatelessSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateDeleteClause(Session session, EntityPath<?> entity, JPQLTemplates templates) {
        this(new DefaultSessionHolder(session), entity, templates);
    }

    public HibernateDeleteClause(SessionHolder session, EntityPath<?> entity, JPQLTemplates templates) {
        this.session = session;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    @Override
    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForDelete(this.queryMixin.getMetadata());
        Query<?> query = this.session.createQuery(serializer.toString());
        for (Map.Entry<Path<?>, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey().toString(), entry.getValue());
        }
        HibernateUtil.setConstants(query, serializer.getConstants(), this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    @Override
    public HibernateDeleteClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.queryMixin.where(p);
        }
        return this;
    }

    public HibernateDeleteClause setLockMode(Path<?> path, LockMode lockMode) {
        this.lockModes.put(path, lockMode);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForDelete(this.queryMixin.getMetadata());
        return serializer.toString();
    }
}

