/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.JoinType;
import com.querydsl.core.dml.InsertClause;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.hibernate.DefaultSessionHolder;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.jpa.hibernate.SessionHolder;
import com.querydsl.jpa.hibernate.StatelessSessionHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.Query;

public class HibernateInsertClause
implements InsertClause<HibernateInsertClause> {
    private final QueryMixin<?> queryMixin = new JPAQueryMixin();
    private final Map<Path<?>, Expression<?>> inserts = new LinkedHashMap();
    private final List<Path<?>> columns = new ArrayList();
    private final List<Object> values = new ArrayList<Object>();
    private SubQueryExpression<?> subQuery;
    private final SessionHolder session;
    private final JPQLTemplates templates;
    private final Map<Path<?>, LockMode> lockModes = new HashMap();

    public HibernateInsertClause(Session session, EntityPath<?> entity) {
        this(new DefaultSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateInsertClause(StatelessSession session, EntityPath<?> entity) {
        this(new StatelessSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateInsertClause(Session session, EntityPath<?> entity, JPQLTemplates templates) {
        this(new DefaultSessionHolder(session), entity, templates);
    }

    public HibernateInsertClause(SessionHolder session, EntityPath<?> entity, JPQLTemplates templates) {
        this.session = session;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    @Override
    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForInsert(this.queryMixin.getMetadata(), this.inserts.isEmpty() ? this.columns : this.inserts.keySet(), this.values, this.subQuery, this.inserts);
        Query<?> query = this.session.createQuery(serializer.toString());
        for (Map.Entry<Path<?>, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey().toString(), entry.getValue());
        }
        HibernateUtil.setConstants(query, serializer.getConstants(), this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    @Override
    public HibernateInsertClause columns(Path<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    @Override
    public HibernateInsertClause select(SubQueryExpression<?> sq) {
        this.subQuery = sq;
        return this;
    }

    public HibernateInsertClause setLockMode(Path<?> path, LockMode lockMode) {
        this.lockModes.put(path, lockMode);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForInsert(this.queryMixin.getMetadata(), this.inserts.isEmpty() ? this.columns : this.inserts.keySet(), this.values, this.subQuery, this.inserts);
        return serializer.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public <T> HibernateInsertClause set(Path<T> path, T value) {
        if (value != null) {
            this.inserts.put(path, Expressions.constant(value));
        } else {
            this.setNull((Path)path);
        }
        return this;
    }

    @Override
    public <T> HibernateInsertClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.inserts.put(path, expression);
        } else {
            this.setNull((Path)path);
        }
        return this;
    }

    @Override
    public <T> HibernateInsertClause setNull(Path<T> path) {
        this.inserts.put(path, Expressions.nullExpression(path));
        return this;
    }

    @Override
    public HibernateInsertClause values(Object ... v) {
        this.values.addAll(Arrays.asList(v));
        return this;
    }
}

