/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.dsl.Param;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.query.Query;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public final class HibernateUtil {
    private static final Set<Class<?>> BUILT_IN = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, BigDecimal.class, byte[].class, Byte[].class, java.util.Date.class, Calendar.class, Date.class, Time.class, Timestamp.class, Locale.class, TimeZone.class, Currency.class, Class.class, Serializable.class, Blob.class, Clob.class)));
    private static final Map<Class<?>, Type> TYPES;

    private HibernateUtil() {
    }

    public static void setConstants(Query<?> query, List<Object> constants, Map<ParamExpression<?>, Object> params) {
        for (int i = 0; i < constants.size(); ++i) {
            Object val = constants.get(i);
            if (val instanceof Param) {
                Param param = (Param)val;
                if ((val = params.get(val)) == null) {
                    throw new ParamNotSetException(param);
                }
            }
            HibernateUtil.setValueWithNumberedLabel(query, i + 1, val);
        }
    }

    private static void setValueWithNumberedLabel(Query<?> query, Integer key, Object val) {
        if (val instanceof Collection) {
            query.setParameterList(key.intValue(), (Collection)val);
        } else if (val instanceof Object[] && !BUILT_IN.contains(val.getClass())) {
            query.setParameterList(key.intValue(), (Object[])val);
        } else if (val instanceof Number && TYPES.containsKey(val.getClass())) {
            query.setParameter(key.intValue(), val, HibernateUtil.getType(val.getClass()));
        } else {
            query.setParameter(key.intValue(), val);
        }
    }

    public static Type getType(Class<?> clazz) {
        return TYPES.get(clazz);
    }

    static {
        HashMap<Class, Object> builder = new HashMap<Class, Object>();
        builder.put(Byte.class, new ByteType());
        builder.put(Short.class, new ShortType());
        builder.put(Integer.class, new IntegerType());
        builder.put(Long.class, new LongType());
        builder.put(BigInteger.class, new BigIntegerType());
        builder.put(Double.class, new DoubleType());
        builder.put(Float.class, new FloatType());
        builder.put(BigDecimal.class, new BigDecimalType());
        builder.put(String.class, new StringType());
        builder.put(Character.class, new CharacterType());
        builder.put(java.util.Date.class, new DateType());
        builder.put(Boolean.class, new BooleanType());
        TYPES = Collections.unmodifiableMap(builder);
    }
}

