/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.util.MathUtils;
import java.util.List;
import java.util.Map;
import javax.persistence.Parameter;
import javax.persistence.Query;

public final class JPAUtil {
    private JPAUtil() {
    }

    public static void setConstants(Query query, List<Object> constants, Map<ParamExpression<?>, Object> params) {
        boolean hasParameters = !query.getParameters().isEmpty();
        for (int i = 0; i < constants.size(); ++i) {
            Object val = constants.get(i);
            if (val instanceof Param) {
                Param param = (Param)val;
                if ((val = params.get(val)) == null) {
                    throw new ParamNotSetException(param);
                }
            }
            if (hasParameters) {
                Class parameterType;
                Parameter parameter = query.getParameter(i + 1);
                Class clazz = parameterType = parameter != null ? parameter.getParameterType() : null;
                if (parameterType != null && !parameterType.isInstance(val) && val instanceof Number && Number.class.isAssignableFrom(parameterType)) {
                    val = MathUtils.cast((Number)val, parameterType);
                }
            }
            query.setParameter(i + 1, val);
        }
    }
}

