/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Logger {
    public static final int LOG_ALL = 0;
    public static final int LOG_INFO_AND_ABOVE = 1;
    public static final int LOG_WARNING_AND_ABOVE = 2;
    public static final int LOG_ERROR_AND_ABOVE = 3;
    public static final int LOG_NOTHING = 4;
    private static Logger instance = new Logger();
    protected int _logLevel = 0;
    protected PrintStream _output1 = System.err;
    protected PrintWriter _output2 = null;

    protected Logger() {
    }

    public static synchronized void setLogger(Logger inst) {
        instance = inst;
    }

    public static void setLogLevel(int level) {
        Logger l = instance;
        if (l != null) {
            l.doSetLogLevel(level);
        }
    }

    public static void setOutput(PrintStream str) {
        Logger l = instance;
        if (l != null) {
            l.doSetOutput(str);
        }
    }

    public static void setOutput(Writer w) {
        Logger l = instance;
        if (l != null) {
            l.doSetOutput(w);
        }
    }

    public static void logInfo(String msg) {
        Logger l = instance;
        if (l != null) {
            l.doLogInfo(msg);
        }
    }

    public static void logWarning(String msg) {
        Logger l = instance;
        if (l != null) {
            l.doLogWarning(msg);
        }
    }

    public static void logError(String msg) {
        Logger l = instance;
        if (l != null) {
            l.doLogError(msg);
        }
    }

    protected void doSetLogLevel(int ll) {
        this._logLevel = ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetOutput(PrintStream str) {
        Logger logger2 = this;
        synchronized (logger2) {
            this._output1 = str;
            this._output2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetOutput(Writer w) {
        Logger logger2 = this;
        synchronized (logger2) {
            this._output1 = null;
            this._output2 = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLogInfo(String msg) {
        if (this._logLevel <= 1 && this.isEnabled()) {
            Logger logger2 = this;
            synchronized (logger2) {
                this.doWrite("INFO: " + msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLogWarning(String msg) {
        if (this._logLevel <= 2 && this.isEnabled()) {
            Logger logger2 = this;
            synchronized (logger2) {
                this.doWrite("WARNING: " + msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLogError(String msg) {
        if (this._logLevel <= 3 && this.isEnabled()) {
            Logger logger2 = this;
            synchronized (logger2) {
                this.doWrite("ERROR: " + msg);
            }
        }
    }

    protected void doWrite(String msg) {
        if (this._output1 != null) {
            this._output1.println(msg);
        } else if (this._output2 != null) {
            this._output2.println(msg);
        }
    }

    protected boolean isEnabled() {
        return this._output1 != null || this._output2 != null;
    }
}

