/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

class AddressContent
implements Externalizable {
    private String address;
    private UUID nodeLiveId;

    AddressContent() {
    }

    protected AddressContent(String address, UUID nodeLiveId) {
        this.address = address;
        this.nodeLiveId = nodeLiveId;
    }

    final String getAddress() {
        return this.address;
    }

    final UUID getNodeLiveId() {
        return this.nodeLiveId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.address);
        out.writeLong(this.nodeLiveId.getMostSignificantBits());
        out.writeLong(this.nodeLiveId.getLeastSignificantBits());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.address = in.readUTF();
        this.nodeLiveId = new UUID(in.readLong(), in.readLong());
    }

    public String toString() {
        return this.address + " " + this.nodeLiveId;
    }
}

