/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import com.qwazr.cluster.ClusterNode;
import com.qwazr.cluster.ClusterNodeAddress;
import com.qwazr.cluster.ClusterNodeJson;
import com.qwazr.cluster.ClusterNodeMap;
import com.qwazr.cluster.ClusterServiceBuilder;
import com.qwazr.cluster.ClusterServiceImpl;
import com.qwazr.cluster.ClusterServiceStatusJson;
import com.qwazr.cluster.ClusterStatusJson;
import com.qwazr.cluster.DatagramListener;
import com.qwazr.cluster.MulticastListener;
import com.qwazr.cluster.ProtocolListener;
import com.qwazr.cluster.ServiceBuilderInterface;
import com.qwazr.server.GenericServer;
import com.qwazr.server.RemoteService;
import com.qwazr.server.ServerException;
import com.qwazr.server.configuration.ServerConfiguration;
import com.qwazr.utils.ArrayUtils;
import com.qwazr.utils.HashUtils;
import com.qwazr.utils.StringUtils;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterManager.class);
    final ClusterNodeMap clusterNodeMap;
    final ClusterNodeAddress me;
    final ClusterNodeAddress webApp;
    final Set<String> myServices;
    final Set<String> myGroups;
    final UUID nodeLiveId;
    private final Set<String> masters;
    private final ProtocolListener protocolListener;
    private final ClusterServiceBuilder serviceBuilder;

    public ClusterManager(GenericServer.Builder builder) throws URISyntaxException, UnknownHostException {
        ServerConfiguration configuration = builder.getConfiguration();
        this.nodeLiveId = HashUtils.newTimeBasedUUID();
        this.me = new ClusterNodeAddress(configuration.webServiceConnector.addressPort, configuration.webServiceConnector.port);
        this.webApp = new ClusterNodeAddress(configuration.webAppConnector.addressPort, configuration.webAppConnector.port);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Server: " + this.me.httpAddressKey + " Groups: " + ArrayUtils.prettyPrint(configuration.groups));
        }
        this.myGroups = configuration.groups != null ? new HashSet<String>(configuration.groups) : null;
        this.myServices = new HashSet<String>();
        if (configuration.masters != null && !configuration.masters.isEmpty()) {
            this.masters = new HashSet<String>();
            configuration.masters.forEach(master -> this.masters.add(new ClusterNodeAddress((String)master, (int)configuration.webServiceConnector.port).httpAddressKey));
        } else {
            this.masters = null;
        }
        this.clusterNodeMap = new ClusterNodeMap(this, this.me.address);
        this.clusterNodeMap.register(this.me.httpAddressKey);
        this.clusterNodeMap.register(this.masters);
        this.protocolListener = configuration.multicastConnector.address != null && configuration.multicastConnector.port != -1 ? new MulticastListener(this, configuration.multicastConnector.address, configuration.multicastConnector.port) : new DatagramListener(this);
        builder.webService(ClusterServiceImpl.class);
        builder.packetListener(this.protocolListener);
        builder.startedListener(server -> {
            this.protocolListener.joinCluster(server.getWebServiceNames());
            this.protocolListener.start();
        });
        builder.shutdownListener(server -> this.protocolListener.leaveCluster());
        builder.contextAttribute(this);
        this.serviceBuilder = new ClusterServiceBuilder(this, new ClusterServiceImpl(this));
    }

    public ClusterServiceBuilder getServiceBuilder() {
        return this.serviceBuilder;
    }

    public boolean isGroup(String group) {
        if (group == null) {
            return true;
        }
        if (this.myGroups == null) {
            return true;
        }
        if (group.isEmpty()) {
            return true;
        }
        return this.myGroups.contains(group);
    }

    public boolean isLeader(String service, String group) throws ServerException {
        SortedSet<String> nodes = this.clusterNodeMap.getGroupService(group, service);
        if (nodes == null || nodes.isEmpty()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No node available for this service/group: " + service + '/' + group);
            }
            return false;
        }
        return this.me.httpAddressKey.equals(nodes.first());
    }

    final ClusterStatusJson getStatus() {
        Map<String, ClusterNode> nodesMap = this.clusterNodeMap.getNodesMap();
        TreeMap<String, ClusterNodeJson> nodesJsonMap = new TreeMap<String, ClusterNodeJson>();
        if (nodesMap != null) {
            long currentMs = System.currentTimeMillis();
            nodesMap.forEach((address, clusterNode) -> {
                Long expirationTimeMs = clusterNode.getExpirationTimeMs();
                Integer timeToLive = expirationTimeMs != null ? Integer.valueOf((int)((expirationTimeMs - currentMs) / 1000L)) : null;
                ClusterNodeJson clusterNodeJson = new ClusterNodeJson(clusterNode.address.httpAddressKey, clusterNode.nodeLiveId, timeToLive, clusterNode.groups, clusterNode.services);
                nodesJsonMap.put((String)address, clusterNodeJson);
            });
        }
        return new ClusterStatusJson(this.me.httpAddressKey, this.myServices.contains("webapps") ? this.webApp.httpAddressKey : null, nodesJsonMap, this.clusterNodeMap.getGroups(), this.clusterNodeMap.getServices(), this.masters, this.protocolListener.getLastExecutionDate());
    }

    final Set<String> getNodes() {
        Map<String, ClusterNode> nodesMap = this.clusterNodeMap.getNodesMap();
        return nodesMap == null ? Collections.emptySet() : nodesMap.keySet();
    }

    final TreeMap<String, ClusterServiceStatusJson.StatusEnum> getServicesStatus(String group) {
        TreeMap<String, ClusterServiceStatusJson.StatusEnum> servicesStatus = new TreeMap<String, ClusterServiceStatusJson.StatusEnum>();
        Set<String> services = this.clusterNodeMap.getServices().keySet();
        if (services == null || services.isEmpty()) {
            return servicesStatus;
        }
        services.forEach(service -> {
            SortedSet<String> nodes = this.getNodesByGroupByService(group, (String)service);
            if (nodes != null && !nodes.isEmpty()) {
                servicesStatus.put((String)service, ClusterServiceStatusJson.findStatus(nodes.size()));
            }
        });
        return servicesStatus;
    }

    final ClusterServiceStatusJson getServiceStatus(String group, String service) {
        SortedSet<String> nodes = this.getNodesByGroupByService(group, service);
        return nodes == null || nodes.isEmpty() ? new ClusterServiceStatusJson() : new ClusterServiceStatusJson(nodes);
    }

    final SortedSet<String> getNodesByGroupByService(String group, String service) {
        if (StringUtils.isEmpty(group)) {
            return this.clusterNodeMap.getByService(service);
        }
        if (StringUtils.isEmpty(service)) {
            return this.clusterNodeMap.getByGroup(group);
        }
        return this.clusterNodeMap.getGroupService(group, service);
    }

    final String getLeaderNode(String group, String service) {
        SortedSet<String> nodes = this.getNodesByGroupByService(group, service);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        return nodes.first();
    }

    final String getRandomNode(String group, String service) {
        SortedSet<String> nodes = this.getNodesByGroupByService(group, service);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        int rand = RandomUtils.nextInt(0, nodes.size());
        Iterator it = nodes.iterator();
        while (true) {
            String node = (String)it.next();
            if (rand == 0) {
                return node;
            }
            --rand;
        }
    }

    <T> T getService(Collection<String> nodes, ServiceBuilderInterface<T> builder) throws URISyntaxException {
        Objects.requireNonNull(builder, "No builder given");
        Objects.requireNonNull(nodes, "No nodes given");
        if (nodes.size() == 0) {
            throw new NullPointerException("No nodes given");
        }
        if (nodes.size() == 1) {
            return this.getService(nodes.iterator().next(), builder);
        }
        return builder.remotes(RemoteService.build(nodes));
    }

    <T> T getService(String node, ServiceBuilderInterface<T> builder) throws URISyntaxException {
        Objects.requireNonNull(builder, "No builder given");
        Objects.requireNonNull(node, "No node given");
        return this.me.httpAddressKey.equals(node) ? builder.local() : builder.remote(RemoteService.of(node).build());
    }

    final boolean isMe(AddressContent message) {
        if (message == null) {
            return false;
        }
        if (this.nodeLiveId.equals(message.getNodeLiveId())) {
            return true;
        }
        return this.me.httpAddressKey.equals(message.getAddress());
    }

    final boolean isMaster(ClusterNodeAddress nodeAddress) {
        if (nodeAddress == null || this.masters == null) {
            return false;
        }
        return this.masters.contains(nodeAddress.httpAddressKey);
    }
}

