/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.ClusterNodeAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

final class ClusterNode {
    final ClusterNodeAddress address;
    final UUID nodeLiveId;
    final Set<String> groups;
    final Set<String> services;
    private volatile Long expirationTimeMs;
    volatile List<String> groupsCache;
    volatile List<String> servicesCache;
    private volatile boolean hasFullInfo;

    ClusterNode(ClusterNodeAddress address, UUID nodeLiveId, Long expirationTimeMs) {
        this.nodeLiveId = nodeLiveId;
        this.address = address;
        this.expirationTimeMs = expirationTimeMs;
        this.groups = new HashSet<String>();
        this.services = new HashSet<String>();
        this.groupsCache = null;
        this.servicesCache = null;
        this.hasFullInfo = false;
    }

    final void setExpirationTime(Long expirationTimeMs) {
        this.expirationTimeMs = expirationTimeMs;
    }

    final Long getExpirationTimeMs() {
        return this.expirationTimeMs;
    }

    final boolean isExpired(long currentTimeMs) {
        Long ns = this.expirationTimeMs;
        return ns == null ? false : currentTimeMs > this.expirationTimeMs;
    }

    final void registerGroups(Collection<String> newGroups) {
        if (newGroups == null) {
            return;
        }
        this.groups.clear();
        this.groups.addAll(newGroups);
        this.groupsCache = new ArrayList<String>(this.groups);
    }

    final void registerServices(Collection<String> newServices) {
        if (newServices == null) {
            return;
        }
        this.services.clear();
        this.services.addAll(newServices);
        this.servicesCache = new ArrayList<String>(this.services);
    }

    final boolean hasFullInfo() {
        return this.hasFullInfo;
    }

    final void setFullInfo() {
        this.hasFullInfo = true;
    }

    final Collection<String> getGroups() {
        return this.groupsCache;
    }

    final Collection<String> getServices() {
        return this.servicesCache;
    }
}

