/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.server.ServerException;
import com.qwazr.utils.StringUtils;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.Response;

class ClusterNodeAddress {
    final URI uri;
    final InetSocketAddress address;
    final String httpAddressKey;

    ClusterNodeAddress(String httpAddress, int defaultPort) {
        try {
            URI u;
            if (!httpAddress.contains("//")) {
                httpAddress = "http://" + httpAddress;
            }
            this.uri = new URI(StringUtils.isEmpty((u = new URI(httpAddress)).getScheme()) ? "http" : u.getScheme(), null, u.getHost(), u.getPort() == -1 ? defaultPort : u.getPort(), null, null, null);
            this.address = new InetSocketAddress(this.uri.getHost(), this.uri.getPort());
            this.httpAddressKey = this.uri.toString().intern();
        }
        catch (URISyntaxException e) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Cannot create node. Wrong address syntax: " + httpAddress, e);
        }
    }
}

