/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import com.qwazr.cluster.ClusterManager;
import com.qwazr.cluster.ClusterNode;
import com.qwazr.cluster.ClusterNodeAddress;
import com.qwazr.cluster.FullContent;
import com.qwazr.utils.LockUtils;
import com.qwazr.utils.StringUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterNodeMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterNodeMap.class);
    private final ClusterManager clusterManager;
    private final InetSocketAddress myAddress;
    private final LockUtils.ReadWriteLock readWriteLock = new LockUtils.ReadWriteLock();
    private final HashMap<String, ClusterNode> nodesMap;
    private final HashMap<String, HashSet<String>> groupsMap;
    private final HashMap<String, HashSet<String>> servicesMap;
    private volatile Cache cache;
    private final SortedSet<String> EMPTY = Collections.unmodifiableSortedSet(new TreeSet());

    ClusterNodeMap(ClusterManager clusterManager, InetSocketAddress myAddress) {
        this.clusterManager = clusterManager;
        this.myAddress = myAddress;
        this.nodesMap = new HashMap();
        this.groupsMap = new HashMap();
        this.servicesMap = new HashMap();
        this.cache = new Cache();
    }

    final SortedSet<String> getGroupService(String group, String service) {
        TreeSet serviceSet;
        Cache cc = this.cache;
        TreeSet groupSet = group == null ? null : (TreeSet)cc.cacheGroupsMap.get(group);
        TreeSet treeSet = serviceSet = service == null ? null : (TreeSet)cc.cacheServicesMap.get(service);
        if (!StringUtils.isEmpty(group) && (groupSet == null || groupSet.isEmpty())) {
            return this.EMPTY;
        }
        if (!StringUtils.isEmpty(service) && (serviceSet == null || serviceSet.isEmpty())) {
            return this.EMPTY;
        }
        if (groupSet == null && serviceSet == null) {
            return this.EMPTY;
        }
        TreeSet<String> nodes = new TreeSet<String>();
        if (groupSet == null) {
            nodes.addAll(serviceSet);
            return nodes;
        }
        if (serviceSet == null) {
            nodes.addAll(groupSet);
            return nodes;
        }
        groupSet.forEach(node -> {
            if (serviceSet.contains(node)) {
                nodes.add((String)node);
            }
        });
        return nodes;
    }

    private static TreeSet<String> getNodes(String key, TreeMap<String, TreeSet<String>> nodesMap) {
        TreeSet<String> nodeSet = nodesMap.get(key);
        TreeSet<String> nodes = new TreeSet<String>();
        if (nodeSet != null) {
            nodes.addAll(nodeSet);
        }
        return nodes;
    }

    final TreeSet<String> getByGroup(String group) {
        return ClusterNodeMap.getNodes(group, this.cache.cacheGroupsMap);
    }

    final TreeSet<String> getByService(String service) {
        return ClusterNodeMap.getNodes(service, this.cache.cacheServicesMap);
    }

    final TreeMap<String, TreeSet<String>> getGroups() {
        return this.cache.cacheGroupsMap;
    }

    final TreeMap<String, TreeSet<String>> getServices() {
        return this.cache.cacheServicesMap;
    }

    final Map<String, ClusterNode> getNodesMap() {
        return this.cache.cacheNodesMap;
    }

    final Set<SocketAddress> getExternalNodeAddresses() {
        return this.cache.externalNodesAddresses;
    }

    final Set<SocketAddress> getFullNodeAddresses() {
        return this.cache.fullNodesAddresses;
    }

    private static void registerSet(Collection<String> keys, HashMap<String, HashSet<String>> nodesMap, String address) {
        for (String key : keys) {
            HashSet<String> nodeSet = nodesMap.get(key);
            if (nodeSet == null) {
                nodeSet = new HashSet();
                nodesMap.put(key, nodeSet);
                nodeSet.add(address);
                continue;
            }
            if (nodeSet.contains(address)) continue;
            nodeSet.add(address);
        }
    }

    private static void unregisterSet(HashMap<String, HashSet<String>> nodesMap, String address) {
        ArrayList toRemove = new ArrayList();
        nodesMap.forEach((key, nodeSet) -> {
            nodeSet.remove(address);
            if (nodeSet.isEmpty()) {
                toRemove.add(key);
            }
        });
        nodesMap.remove(address);
        toRemove.forEach(nodesMap::remove);
    }

    private ClusterNode put(String httpAddress, UUID nodeLiveId, Long expirationTimeNs) {
        ClusterNodeAddress clusterNodeAddress = new ClusterNodeAddress(httpAddress, 9091);
        ClusterNode node = new ClusterNode(clusterNodeAddress, nodeLiveId, expirationTimeNs);
        this.nodesMap.put(clusterNodeAddress.httpAddressKey, node);
        return node;
    }

    private ClusterNode registerNode(String httpAddress, UUID nodeLiveId, Long expirationTimeMs) {
        ClusterNode node = this.nodesMap.get(httpAddress);
        if (node == null) {
            return this.put(httpAddress, nodeLiveId, expirationTimeMs);
        }
        if (nodeLiveId == null) {
            return node;
        }
        if (nodeLiveId.equals(node.nodeLiveId)) {
            node.setExpirationTime(expirationTimeMs);
            return node;
        }
        return this.put(httpAddress, nodeLiveId, expirationTimeMs);
    }

    final ClusterNode register(String httpAddress) {
        if (httpAddress == null) {
            return null;
        }
        return this.readWriteLock.write(() -> {
            ClusterNode clusterNode = this.registerNode(httpAddress, null, null);
            this.cache = new Cache();
            return clusterNode;
        });
    }

    final void register(Collection<String> httpAddresses) {
        if (httpAddresses == null) {
            return;
        }
        httpAddresses.forEach(address -> this.register((String)address));
    }

    final ClusterNode registerAddress(AddressContent message, Long expirationTimeMs) {
        if (message == null) {
            return null;
        }
        String address = message.getAddress();
        if (address == null) {
            return null;
        }
        return this.readWriteLock.writeEx(() -> {
            ClusterNode clusterNode = this.registerNode(address, message.getNodeLiveId(), expirationTimeMs);
            this.cache = new Cache();
            return clusterNode;
        });
    }

    final ClusterNode registerFull(FullContent message, Long expirationTimeMs) {
        if (message == null) {
            return null;
        }
        String address = message.getAddress();
        if (address == null) {
            return null;
        }
        return this.readWriteLock.writeEx(() -> {
            ClusterNode clusterNode = this.registerNode(address, message.getNodeLiveId(), expirationTimeMs);
            ClusterNodeMap.unregisterSet(this.groupsMap, clusterNode.address.httpAddressKey);
            ClusterNodeMap.unregisterSet(this.servicesMap, clusterNode.address.httpAddressKey);
            clusterNode.registerGroups(message.groups);
            clusterNode.registerServices(message.services);
            ClusterNodeMap.registerSet(message.groups, this.groupsMap, address);
            ClusterNodeMap.registerSet(message.services, this.servicesMap, address);
            clusterNode.hasFullInfo();
            this.cache = new Cache();
            return clusterNode;
        });
    }

    private void unregisterAll(String address) {
        ClusterNode clusterNode;
        ClusterNodeAddress nodeAddress;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Unregister " + address + " from " + this.myAddress);
        }
        ClusterNodeAddress clusterNodeAddress = nodeAddress = (clusterNode = this.nodesMap.get(address)) != null ? clusterNode.address : new ClusterNodeAddress(address, 9091);
        if (clusterNode != null) {
            clusterNode.registerGroups(Collections.emptyList());
            clusterNode.registerServices(Collections.emptyList());
        }
        ClusterNodeMap.unregisterSet(this.groupsMap, nodeAddress.httpAddressKey);
        ClusterNodeMap.unregisterSet(this.servicesMap, nodeAddress.httpAddressKey);
        if (!this.clusterManager.isMaster(nodeAddress)) {
            this.nodesMap.remove(nodeAddress.httpAddressKey);
        }
    }

    final void unregister(AddressContent message) {
        if (message == null) {
            return;
        }
        this.readWriteLock.writeEx(() -> {
            this.unregisterAll(message.getAddress());
            this.cache = new Cache();
        });
    }

    final synchronized void removeExpired() {
        ArrayList deleteAdresses = new ArrayList();
        long currentMs = System.currentTimeMillis();
        this.readWriteLock.writeEx(() -> {
            this.nodesMap.forEach((address, node) -> {
                if (node.isExpired(currentMs)) {
                    deleteAdresses.add(address);
                }
            });
            if (deleteAdresses.isEmpty()) {
                return;
            }
            deleteAdresses.forEach(this::unregisterAll);
            this.cache = new Cache();
        });
    }

    private class Cache {
        private final HashMap<String, ClusterNode> cacheNodesMap;
        private final Set<SocketAddress> fullNodesAddresses;
        private final Set<SocketAddress> externalNodesAddresses = new HashSet<SocketAddress>();
        private final TreeMap<String, TreeSet<String>> cacheGroupsMap;
        private final TreeMap<String, TreeSet<String>> cacheServicesMap;

        private Cache() {
            this.fullNodesAddresses = new HashSet<SocketAddress>();
            this.cacheNodesMap = new HashMap();
            ClusterNodeMap.this.nodesMap.forEach((address, clusterNode) -> {
                if (!ClusterNodeMap.this.myAddress.equals(clusterNode.address.address)) {
                    this.externalNodesAddresses.add(clusterNode.address.address);
                }
                this.fullNodesAddresses.add(clusterNode.address.address);
                this.cacheNodesMap.put((String)address, (ClusterNode)clusterNode);
            });
            this.cacheGroupsMap = new TreeMap();
            ClusterNodeMap.this.groupsMap.forEach((key, nodes) -> this.cacheGroupsMap.put((String)key, new TreeSet(nodes)));
            this.cacheServicesMap = new TreeMap();
            ClusterNodeMap.this.servicesMap.forEach((key, nodes) -> this.cacheServicesMap.put((String)key, new TreeSet(nodes)));
        }
    }
}

