/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import com.qwazr.cluster.FullContent;
import com.qwazr.cluster.MessageContent;
import java.io.Externalizable;
import java.util.Set;
import java.util.UUID;

enum ClusterProtocol {
    join('J', FullContent.class),
    notify('N', AddressContent.class),
    forward('F', FullContent.class),
    reply('R', FullContent.class),
    alive('A', AddressContent.class),
    leave('L', AddressContent.class);

    static final String CHAR_HEADER = "QWAZR";
    final char cmd;
    final Class<? extends Externalizable> messageClass;

    private ClusterProtocol(char cmd, Class<? extends Externalizable> messageClass) {
        this.cmd = cmd;
        this.messageClass = messageClass;
    }

    static final ClusterProtocol findCommand(char cmd) {
        for (ClusterProtocol command : ClusterProtocol.values()) {
            if (command.cmd != cmd) continue;
            return command;
        }
        throw new IllegalArgumentException("Command not found: " + cmd);
    }

    static final MessageContent newJoin(String address, UUID nodeLiveId, Set<String> groups, Set<String> services) {
        return new MessageContent(join, new FullContent(address, nodeLiveId, groups, services));
    }

    static final MessageContent newNotify(AddressContent address) {
        return new MessageContent(notify, address);
    }

    static final MessageContent newForward(String address, UUID nodeLiveId, Set<String> groups, Set<String> services) {
        return new MessageContent(forward, new FullContent(address, nodeLiveId, groups, services));
    }

    static final MessageContent newReply(String address, UUID nodeLiveId, Set<String> groups, Set<String> services) {
        return new MessageContent(reply, new FullContent(address, nodeLiveId, groups, services));
    }

    static final MessageContent newAlive(String address, UUID nodeLiveId) {
        return new MessageContent(alive, new AddressContent(address, nodeLiveId));
    }

    static final MessageContent newLeave(String address, UUID nodeLiveId) {
        return new MessageContent(leave, new AddressContent(address, nodeLiveId));
    }
}

