/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.ClusterManager;
import com.qwazr.server.BaseServer;
import com.qwazr.server.GenericServer;
import com.qwazr.server.WelcomeShutdownService;
import com.qwazr.server.configuration.ServerConfiguration;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.OperationsException;
import javax.servlet.ServletException;

public class ClusterServer
implements BaseServer {
    private final GenericServer server;
    private final ClusterManager clusterManager;
    private static volatile ClusterServer INSTANCE;

    private ClusterServer(ServerConfiguration serverConfiguration) throws IOException, URISyntaxException {
        GenericServer.Builder builder = GenericServer.of(serverConfiguration, null).webService(WelcomeShutdownService.class);
        this.clusterManager = new ClusterManager(builder);
        this.server = builder.build();
    }

    public ClusterServer(Map<String, String> properties) throws IOException, URISyntaxException {
        this(ServerConfiguration.of(properties).build());
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public GenericServer getServer() {
        return this.server;
    }

    public static ClusterServer getInstance() {
        return INSTANCE;
    }

    public static synchronized void main(String ... args) throws IOException, ReflectiveOperationException, OperationsException, ServletException, MBeanException, URISyntaxException, InterruptedException {
        ClusterServer.shutdown();
        INSTANCE = new ClusterServer(new ServerConfiguration(args));
        INSTANCE.start();
    }

    public static synchronized void shutdown() {
        if (INSTANCE == null) {
            return;
        }
        INSTANCE.stop();
        INSTANCE = null;
    }
}

