/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.ClusterManager;
import com.qwazr.cluster.ClusterServiceInterface;
import com.qwazr.cluster.ClusterServiceStatusJson;
import com.qwazr.cluster.ClusterStatusJson;
import com.qwazr.server.AbstractServiceImpl;
import com.qwazr.server.ServerException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.Response;

class ClusterServiceImpl
extends AbstractServiceImpl
implements ClusterServiceInterface {
    private ClusterManager manager;

    ClusterServiceImpl(ClusterManager manager) {
        this.manager = manager;
    }

    public ClusterServiceImpl() {
        this(null);
    }

    @PostConstruct
    public void init() {
        this.manager = this.getContextAttribute(ClusterManager.class);
    }

    @Override
    public ClusterStatusJson getStatus() {
        try {
            return this.manager.getStatus();
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }

    @Override
    public SortedSet<String> getNodes() {
        try {
            return new TreeSet<String>(this.manager.getNodes());
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }

    @Override
    public SortedSet<String> getActiveNodesByService(String serviceName, String group) {
        if (serviceName == null) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE).getJsonException();
        }
        try {
            return this.manager.getNodesByGroupByService(group, serviceName);
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }

    @Override
    public String getActiveNodeRandomByService(String serviceName, String group) {
        if (serviceName == null) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE).getJsonException();
        }
        try {
            return this.manager.getRandomNode(group, serviceName);
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }

    @Override
    public String getActiveNodeLeaderByService(String serviceName, String group) {
        if (serviceName == null) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE).getJsonException();
        }
        try {
            return this.manager.getLeaderNode(group, serviceName);
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }

    @Override
    public SortedMap<String, ClusterServiceStatusJson.StatusEnum> getServiceMap(String group) {
        try {
            return this.manager.getServicesStatus(group);
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }

    @Override
    public ClusterServiceStatusJson getServiceStatus(String serviceName, String group) {
        try {
            return this.manager.getServiceStatus(group, serviceName);
        }
        catch (ServerException e) {
            throw e.getJsonException();
        }
    }
}

