/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.ClusterServiceStatusJson;
import com.qwazr.cluster.ClusterStatusJson;
import com.qwazr.server.ServiceInterface;
import com.qwazr.server.ServiceName;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@RolesAllowed(value={"cluster"})
@Path(value="/cluster")
@ServiceName(value="cluster")
public interface ClusterServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "cluster";

    @GET
    @Path(value="/")
    @Produces(value={"application/json; charset=UTF-8"})
    public ClusterStatusJson getStatus();

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json; charset=UTF-8"})
    public SortedSet<String> getNodes();

    @GET
    @Path(value="/services")
    @Produces(value={"application/json; charset=UTF-8"})
    public SortedMap<String, ClusterServiceStatusJson.StatusEnum> getServiceMap(@QueryParam(value="group") String var1);

    @GET
    @Path(value="/services/{service_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public ClusterServiceStatusJson getServiceStatus(@PathParam(value="service_name") String var1, @QueryParam(value="group") String var2);

    @GET
    @Path(value="/services/{service_name}/active")
    @Produces(value={"application/json; charset=UTF-8"})
    public SortedSet<String> getActiveNodesByService(@PathParam(value="service_name") String var1, @QueryParam(value="group") String var2);

    @GET
    @Path(value="/services/{service_name}/active/random")
    @Produces(value={"text/plain"})
    public String getActiveNodeRandomByService(@PathParam(value="service_name") String var1, @QueryParam(value="group") String var2);

    @GET
    @Path(value="/services/{service_name}/active/leader")
    @Produces(value={"text/plain"})
    public String getActiveNodeLeaderByService(@PathParam(value="service_name") String var1, @QueryParam(value="group") String var2);
}

