/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.SortedSet;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClusterServiceStatusJson {
    public final String leader;
    public final StatusEnum status;
    public final int active_count;
    public final SortedSet<String> active;

    public ClusterServiceStatusJson() {
        this.leader = "";
        this.status = null;
        this.active_count = 0;
        this.active = null;
    }

    public ClusterServiceStatusJson(SortedSet<String> nodes) {
        this.active = nodes;
        this.leader = nodes != null ? (!nodes.isEmpty() ? nodes.first() : null) : null;
        this.active_count = this.active == null ? 0 : this.active.size();
        this.status = ClusterServiceStatusJson.findStatus(this.active_count);
    }

    public static StatusEnum findStatus(int active_count) {
        if (active_count == 0) {
            return StatusEnum.failure;
        }
        return StatusEnum.ok;
    }

    public static enum StatusEnum {
        ok,
        failure;

    }
}

