/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.cluster.ClusterServiceInterface;
import com.qwazr.cluster.ClusterServiceStatusJson;
import com.qwazr.cluster.ClusterStatusJson;
import com.qwazr.server.RemoteService;
import com.qwazr.server.client.JsonClientAbstract;
import com.qwazr.utils.UBuilder;
import com.qwazr.utils.http.HttpRequest;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.http.client.methods.HttpGet;

class ClusterSingleClient
extends JsonClientAbstract
implements ClusterServiceInterface {
    public static final TypeReference<TreeSet<String>> TreeSetStringClusterNodeJsonTypeRef = new TypeReference<TreeSet<String>>(){};
    public static final TypeReference<TreeMap<String, ClusterServiceStatusJson.StatusEnum>> MapStringStatusEnumTypeRef = new TypeReference<TreeMap<String, ClusterServiceStatusJson.StatusEnum>>(){};

    ClusterSingleClient(RemoteService remote) {
        super(remote);
    }

    @Override
    public ClusterStatusJson getStatus() {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster");
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, ClusterStatusJson.class, valid200);
    }

    public TreeSet<String> getNodes() {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster/nodes");
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, TreeSetStringClusterNodeJsonTypeRef, valid200);
    }

    public TreeMap<String, ClusterServiceStatusJson.StatusEnum> getServiceMap(String group) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster/services").setParameter("group", group);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, MapStringStatusEnumTypeRef, valid200);
    }

    @Override
    public ClusterServiceStatusJson getServiceStatus(String service_name, String group) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster/services/", service_name).setParameter("group", group);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, ClusterServiceStatusJson.class, valid200);
    }

    public TreeSet<String> getActiveNodesByService(String service_name, String group) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster/services/", service_name, "/active").setParameter("group", group);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, TreeSetStringClusterNodeJsonTypeRef, valid200);
    }

    @Override
    public String getActiveNodeRandomByService(String service_name, String group) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster/services/" + service_name + "/active/random").setParameter("group", group);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeString(request, null, null, valid200TextPlain);
    }

    @Override
    public String getActiveNodeLeaderByService(String service_name, String group) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/cluster/services/" + service_name + "/active/leader").setParameter("group", group);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeString(request, null, null, valid200TextPlain);
    }
}

