/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qwazr.cluster.ClusterNodeJson;
import com.qwazr.cluster.ClusterServiceStatusJson;
import com.qwazr.server.ServerException;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClusterStatusJson {
    public final String me;
    public final String webapp;
    public final TreeMap<String, TreeSet<String>> groups;
    public final TreeMap<String, ClusterServiceStatusJson.StatusEnum> services;
    public final Date last_keep_alive_execution;
    public final TreeMap<String, ClusterNodeJson> active_nodes;
    public final TreeSet<String> masters;

    public ClusterStatusJson() {
        this.me = null;
        this.webapp = null;
        this.groups = null;
        this.services = null;
        this.last_keep_alive_execution = null;
        this.active_nodes = null;
        this.masters = null;
    }

    public ClusterStatusJson(String me, String webapp, TreeMap<String, ClusterNodeJson> nodesMap, TreeMap<String, TreeSet<String>> groups, TreeMap<String, TreeSet<String>> services, Set<String> masters, Date lastKeepAliveExecution) throws ServerException {
        this.me = me;
        this.webapp = webapp;
        this.groups = groups;
        this.services = new TreeMap();
        if (services != null) {
            services.forEach((service, nodesSet) -> this.services.put((String)service, ClusterServiceStatusJson.findStatus(nodesSet.size())));
        }
        this.masters = masters == null || masters.isEmpty() ? null : new TreeSet<String>(masters);
        this.last_keep_alive_execution = lastKeepAliveExecution;
        this.active_nodes = nodesMap;
    }
}

