/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import com.qwazr.cluster.ClusterManager;
import com.qwazr.cluster.ClusterNode;
import com.qwazr.cluster.ClusterProtocol;
import com.qwazr.cluster.FullContent;
import com.qwazr.cluster.MessageContent;
import com.qwazr.cluster.ProtocolListener;
import com.qwazr.utils.SerializationUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.URISyntaxException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatagramListener
extends ProtocolListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramListener.class);

    DatagramListener(ClusterManager manager) {
        super(manager);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Start Datagram listener " + manager.me.httpAddressKey);
        }
    }

    final void acceptJoin(FullContent message) throws URISyntaxException, IOException {
        ClusterNode node = this.registerNode(message);
        ClusterProtocol.newReply(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(node.address.address);
        ClusterProtocol.newNotify(message).send(this.manager.clusterNodeMap.getExternalNodeAddresses());
    }

    final void acceptNotify(AddressContent message) throws URISyntaxException, IOException {
        ClusterNode clusterNode = this.registerNode(message);
        if (clusterNode.nodeLiveId != null && message.getNodeLiveId().equals(clusterNode.nodeLiveId) && clusterNode.hasFullInfo()) {
            return;
        }
        ClusterProtocol.newForward(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(clusterNode.address.address);
    }

    final void acceptAlive(AddressContent message) throws URISyntaxException, IOException {
        ClusterProtocol.newNotify(message).send(this.manager.clusterNodeMap.getFullNodeAddresses());
    }

    final void acceptForward(FullContent message) throws URISyntaxException, IOException {
        ClusterNode node = this.registerNode(message);
        ClusterProtocol.newReply(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(node.address.address);
    }

    final void acceptReply(FullContent message) throws URISyntaxException, IOException {
        this.registerNode(message);
    }

    @Override
    public final void acceptPacket(DatagramPacket datagramPacket) throws IOException, ReflectiveOperationException, URISyntaxException {
        MessageContent message = (MessageContent)SerializationUtils.fromDefaultCompressedBytes(datagramPacket.getData());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.manager.me.httpAddressKey + " DATAGRAMPACKET FROM: " + datagramPacket.getAddress() + " " + (Object)((Object)message.getCommand()) + " " + message.getContent());
        }
        switch (message.getCommand()) {
            case join: {
                this.acceptJoin((FullContent)message.getContent());
                break;
            }
            case notify: {
                this.acceptNotify((AddressContent)message.getContent());
                break;
            }
            case forward: {
                this.acceptForward((FullContent)message.getContent());
                break;
            }
            case reply: {
                this.acceptReply((FullContent)message.getContent());
                break;
            }
            case alive: {
                this.acceptAlive((AddressContent)message.getContent());
                break;
            }
            case leave: {
                this.manager.clusterNodeMap.unregister((AddressContent)message.getContent());
            }
        }
    }

    @Override
    protected synchronized void joinCluster(Collection<String> services) {
        super.joinCluster(services);
        try {
            ClusterProtocol.newJoin(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(this.manager.clusterNodeMap.getFullNodeAddresses());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected synchronized void leaveCluster() {
        try {
            ClusterProtocol.newLeave(this.manager.me.httpAddressKey, this.manager.nodeLiveId).send(this.manager.clusterNodeMap.getExternalNodeAddresses());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void runner() {
        try {
            ClusterProtocol.newAlive(this.manager.me.httpAddressKey, this.manager.nodeLiveId).send(this.manager.clusterNodeMap.getExternalNodeAddresses());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        finally {
            super.runner();
        }
    }
}

