/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

class FullContent
extends AddressContent {
    public final Set<String> groups;
    public final Set<String> services;

    FullContent() {
        this.groups = new HashSet<String>();
        this.services = new HashSet<String>();
    }

    FullContent(String address, UUID nodeLiveId, Set<String> groups, Set<String> services) {
        super(address, nodeLiveId);
        this.groups = groups;
        this.services = services;
    }

    private static void writeCollection(Collection<String> collection, ObjectOutput out) throws IOException {
        if (collection != null) {
            out.writeInt(collection.size());
            for (String s : collection) {
                out.writeUTF(s);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        FullContent.writeCollection(this.groups, out);
        FullContent.writeCollection(this.services, out);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        while (size-- > 0) {
            this.groups.add(in.readUTF());
        }
        size = in.readInt();
        while (size-- > 0) {
            this.services.add(in.readUTF());
        }
    }

    @Override
    public final String toString() {
        return super.toString() + " " + this.groups.size() + "/" + this.services.size();
    }
}

