/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.ClusterProtocol;
import com.qwazr.utils.DatagramUtils;
import com.qwazr.utils.StringUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageContent
implements Externalizable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageContent.class);
    private ClusterProtocol command;
    private Externalizable content;

    public MessageContent() {
        this(null, null);
    }

    MessageContent(ClusterProtocol command, Externalizable content) {
        this.command = command;
        this.content = content;
    }

    final ClusterProtocol getCommand() {
        return this.command;
    }

    final <T extends Externalizable> T getContent() {
        return (T)this.content;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF("QWAZR");
        out.writeChar(this.command.cmd);
        this.content.writeExternal(out);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (!"QWAZR".equals(in.readUTF())) {
            throw new IOException("Unknown UDP message (wrong header)");
        }
        this.command = ClusterProtocol.findCommand(in.readChar());
        try {
            this.content = this.command.messageClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
        this.content.readExternal(in);
    }

    final MessageContent send(Collection<SocketAddress> recipients) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send " + this.command.name() + " to " + StringUtils.join(recipients, ","));
        }
        DatagramUtils.send((Serializable)this, recipients);
        return this;
    }

    final MessageContent send(SocketAddress socketAddress) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send " + this.command.name() + " to " + socketAddress);
        }
        DatagramUtils.send((Serializable)this, socketAddress);
        return this;
    }
}

