/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import com.qwazr.cluster.ClusterManager;
import com.qwazr.cluster.ClusterProtocol;
import com.qwazr.cluster.MessageContent;
import com.qwazr.cluster.ProtocolListener;
import com.qwazr.utils.SerializationUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MulticastListener
extends ProtocolListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastListener.class);
    private final SocketAddress multicastSocketAddress;

    MulticastListener(ClusterManager manager, String multicastAddress, Integer multicastPort) {
        super(manager);
        this.multicastSocketAddress = new InetSocketAddress(multicastAddress, (int)multicastPort);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Start multicast listener: " + this.multicastSocketAddress);
        }
    }

    @Override
    public final void acceptPacket(DatagramPacket datagramPacket) throws IOException, ReflectiveOperationException, URISyntaxException {
        MessageContent message = (MessageContent)SerializationUtils.fromDefaultCompressedBytes(datagramPacket.getData());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.manager.me.httpAddressKey + " MULTICASTPACKET FROM: " + datagramPacket.getAddress() + " " + (Object)((Object)message.getCommand()) + " " + message.getContent());
        }
        switch (message.getCommand()) {
            case join: {
                this.registerNode((AddressContent)message.getContent());
                ClusterProtocol.newForward(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(this.multicastSocketAddress);
                break;
            }
            case forward: {
                this.registerNode((AddressContent)message.getContent());
                break;
            }
            case leave: {
                this.manager.clusterNodeMap.unregister((AddressContent)message.getContent());
            }
        }
    }

    @Override
    protected synchronized void joinCluster(Collection<String> services) {
        super.joinCluster(services);
        try {
            ClusterProtocol.newJoin(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(this.multicastSocketAddress);
        }
        catch (IOException e) {
            LOGGER.error("Unable to reach " + this.multicastSocketAddress, e);
        }
    }

    @Override
    protected synchronized void leaveCluster() {
        try {
            ClusterProtocol.newLeave(this.manager.me.httpAddressKey, this.manager.nodeLiveId).send(this.multicastSocketAddress);
        }
        catch (IOException e) {
            LOGGER.error("Unable to reach " + this.multicastSocketAddress, e);
        }
    }

    @Override
    protected void runner() {
        try {
            ClusterProtocol.newForward(this.manager.me.httpAddressKey, this.manager.nodeLiveId, this.manager.myGroups, this.manager.myServices).send(this.multicastSocketAddress);
        }
        catch (IOException e) {
            LOGGER.error("Error while running the multicast listener. The thread is stopped.", e);
        }
        finally {
            super.runner();
        }
    }
}

