/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.AddressContent;
import com.qwazr.cluster.ClusterManager;
import com.qwazr.cluster.ClusterNode;
import com.qwazr.cluster.FullContent;
import com.qwazr.server.UdpServerThread;
import com.qwazr.utils.concurrent.PeriodicThread;
import java.util.Collection;

abstract class ProtocolListener
extends PeriodicThread
implements UdpServerThread.PacketListener {
    protected final ClusterManager manager;
    private static final int DEFAULT_PERIOD_SEC = 120;
    private static final int TWICE_DEFAULT_PERIOD_MS = 240000;

    protected ProtocolListener(ClusterManager manager) {
        super("KeepAliveThread", 120);
        this.setDaemon(true);
        this.manager = manager;
    }

    protected synchronized void joinCluster(Collection<String> services) {
        if (services != null) {
            this.manager.myServices.clear();
            this.manager.myServices.addAll(services);
        }
    }

    protected ClusterNode registerNode(AddressContent message) {
        Long expirationTime;
        Long l = expirationTime = this.manager.isMe(message) ? null : Long.valueOf(System.currentTimeMillis() + 240000L);
        if (message instanceof FullContent) {
            return this.manager.clusterNodeMap.registerFull((FullContent)message, expirationTime);
        }
        return this.manager.clusterNodeMap.registerAddress(message, expirationTime);
    }

    protected abstract void leaveCluster();

    @Override
    protected void runner() {
        this.manager.clusterNodeMap.removeExpired();
    }
}

