/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.cluster;

import com.qwazr.cluster.ClusterManager;
import com.qwazr.cluster.ServiceBuilderInterface;
import com.qwazr.server.RemoteService;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Consumer;

public class ServiceBuilderAbstract<T>
implements ServiceBuilderInterface<T> {
    protected final ClusterManager clusterManager;
    protected final String serviceName;
    protected final T local;

    protected ServiceBuilderAbstract(ClusterManager clusterManager, String serviceName, T local) {
        this.clusterManager = clusterManager;
        this.serviceName = serviceName;
        this.local = local;
    }

    @Override
    public final T getService(String node) throws URISyntaxException {
        if (node == null) {
            return null;
        }
        if (this.local != null && this.clusterManager != null && node.equals(this.clusterManager.me.httpAddressKey)) {
            return this.local;
        }
        return this.remote(RemoteService.of(node).build());
    }

    @Override
    public final T getService(Collection<String> nodes) throws URISyntaxException {
        return this.remotes(RemoteService.build(nodes));
    }

    @Override
    public T getActive(String group) throws URISyntaxException {
        Objects.requireNonNull(this.serviceName, "The service name is missing");
        SortedSet<String> nodes = this.clusterManager.getNodesByGroupByService(group, this.serviceName);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        return nodes.size() == 1 ? this.getService(nodes.first()) : this.getService(nodes);
    }

    @Override
    public int active(String group, Consumer<T> consumer) throws URISyntaxException {
        Objects.requireNonNull(this.serviceName, "The service name is missing");
        SortedSet<String> nodes = this.clusterManager.getNodesByGroupByService(group, this.serviceName);
        if (nodes == null || nodes.isEmpty()) {
            return 0;
        }
        for (String node : nodes) {
            consumer.accept(this.getService(node));
        }
        return nodes.size();
    }

    @Override
    public final T getRandom(String group) throws URISyntaxException {
        Objects.requireNonNull(this.serviceName, "The service name is missing");
        return this.getService(this.clusterManager.getRandomNode(group, this.serviceName));
    }

    @Override
    public final T getLeader(String group) throws URISyntaxException {
        Objects.requireNonNull(this.serviceName, "The service name is missing");
        return this.getService(this.clusterManager.getLeaderNode(group, this.serviceName));
    }

    @Override
    public final T local() {
        return this.local;
    }
}

