/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database;

import com.qwazr.database.TableServiceInterface;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.KeyStore;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TableBuilder {
    public final String tableName;
    public final KeyStore.Impl implementation;
    public final Map<String, ColumnDefinition> columns;

    public TableBuilder(String tableName, KeyStore.Impl implementation) {
        this.tableName = tableName;
        this.implementation = implementation;
        this.columns = new LinkedHashMap<String, ColumnDefinition>();
    }

    public TableBuilder setColumn(String name, ColumnDefinition.Type type, ColumnDefinition.Mode mode) {
        this.columns.put(name, new ColumnDefinition(type, mode));
        return this;
    }

    public void build(TableServiceInterface tableService) {
        Set<String> tables = tableService.list();
        if (!tables.contains(this.tableName)) {
            tableService.createTable(this.tableName, this.implementation);
        }
        Map<String, ColumnDefinition> existingColumns = tableService.getColumns(this.tableName);
        this.columns.forEach((columnName, columnDefinition) -> {
            if (!existingColumns.containsKey(columnName)) {
                tableService.setColumn(this.tableName, (String)columnName, (ColumnDefinition)columnDefinition);
            }
        });
        existingColumns.keySet().forEach(columnName -> {
            if (!this.columns.containsKey(columnName)) {
                tableService.removeColumn(this.tableName, (String)columnName);
            }
        });
    }
}

