/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database;

import com.qwazr.database.TableServiceImpl;
import com.qwazr.database.TableServiceInterface;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.model.TableRequest;
import com.qwazr.database.model.TableRequestResult;
import com.qwazr.database.store.CollectorInterface;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.Query;
import com.qwazr.database.store.Table;
import com.qwazr.database.store.Tables;
import com.qwazr.server.GenericServer;
import com.qwazr.server.ServerException;
import com.qwazr.utils.LockUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.roaringbitmap.RoaringBitmap;

public class TableManager {
    private final LockUtils.ReadWriteLock rwl = new LockUtils.ReadWriteLock();
    private final File directory;
    private final TableServiceInterface service;

    public static TableManager getNewInstance(GenericServer.Builder builder) throws IOException {
        File tableDir = new File(builder.getConfiguration().dataDirectory, "table");
        if (!tableDir.exists()) {
            tableDir.mkdir();
        }
        TableManager tableManager = new TableManager(tableDir);
        if (builder != null) {
            builder.webService(TableServiceImpl.class);
            builder.shutdownListener(server -> Tables.closeAll());
            builder.contextAttribute(tableManager);
        }
        return tableManager;
    }

    public TableManager(File directory) throws ServerException, IOException {
        this.directory = directory;
        this.service = new TableServiceImpl(this);
    }

    public TableServiceInterface getService() {
        return this.service;
    }

    private Table getTable(String tableName) throws IOException {
        File dbDirectory = new File(this.directory, tableName);
        if (!dbDirectory.exists()) {
            throw new ServerException(Response.Status.NOT_FOUND, "Table not found: " + tableName);
        }
        return Tables.getInstance(dbDirectory, null);
    }

    public void createTable(String tableName, KeyStore.Impl storeImpl) throws IOException {
        this.rwl.writeEx(() -> {
            File dbDirectory = new File(this.directory, tableName);
            if (dbDirectory.exists()) {
                throw new ServerException(Response.Status.CONFLICT, "The table already exists: " + tableName);
            }
            dbDirectory.mkdir();
            if (!dbDirectory.exists()) {
                throw new ServerException(Response.Status.INTERNAL_SERVER_ERROR, "The directory cannot be created: " + dbDirectory.getAbsolutePath());
            }
            Tables.getInstance(dbDirectory, storeImpl);
        });
    }

    public Set<String> getNameSet() {
        return this.rwl.read(() -> {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (File file : this.directory.listFiles(FileFilterUtils.directoryFileFilter())) {
                if (file.isHidden()) continue;
                names.add(file.getName());
            }
            return names;
        });
    }

    public Map<String, ColumnDefinition> getColumns(String tableName) throws IOException {
        return this.rwl.readEx(() -> this.getTable(tableName).getColumns());
    }

    public void setColumn(String tableName, String columnName, ColumnDefinition columnDefinition) throws IOException {
        this.rwl.writeEx(() -> this.getTable(tableName).setColumn(columnName, columnDefinition));
    }

    public void removeColumn(String tableName, String columnName) throws IOException {
        this.rwl.writeEx(() -> this.getTable(tableName).removeColumn(columnName));
    }

    public List<Object> getColumnTerms(String tableName, String columnName, Integer start, Integer rows) throws IOException {
        return this.rwl.readEx(() -> this.getTable(tableName).getColumnTerms(columnName, start == null ? 0 : start, rows == null ? 10 : rows));
    }

    public List<String> getColumnTermKeys(String tableName, String columnName, String term, Integer start, Integer rows) throws IOException {
        return this.rwl.readEx(() -> this.getTable(tableName).getColumnTermKeys(columnName, term, start == null ? 0 : start, rows == null ? 10 : rows));
    }

    public void deleteTable(String tableName) throws IOException {
        this.rwl.writeEx(() -> {
            File dbDirectory = new File(this.directory, tableName);
            if (!dbDirectory.exists()) {
                throw new ServerException(Response.Status.NOT_FOUND, "Table not found: " + tableName);
            }
            Tables.delete(dbDirectory);
            FileUtils.deleteDirectory(dbDirectory);
        });
    }

    public void upsertRow(String tableName, String row_id, Map<String, Object> nodeMap) throws IOException {
        this.rwl.readEx(() -> this.getTable(tableName).upsertRow(row_id, nodeMap));
    }

    public int upsertRows(String tableName, List<Map<String, Object>> rows) throws IOException {
        return this.rwl.readEx(() -> this.getTable(tableName).upsertRows(rows));
    }

    public LinkedHashMap<String, Object> getRow(String tableName, String key, Set<String> columns) throws IOException {
        return this.rwl.readEx(() -> {
            Table table = this.getTable(tableName);
            LinkedHashMap<String, Object> row = table.getRow(key, columns);
            if (row == null) {
                throw new ServerException(Response.Status.NOT_FOUND, "Row not found: " + key);
            }
            return row;
        });
    }

    public List<Map<String, Object>> getRows(String tableName, Set<String> columns, Set<String> keys) throws IOException {
        return this.rwl.readEx(() -> {
            Table table = this.getTable(tableName);
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            table.getRows(keys, columns, rows);
            return rows;
        });
    }

    public List<String> getPrimaryKeys(String tableName, Integer start, Integer rows) throws IOException {
        return this.rwl.readEx(() -> this.getTable(tableName).getPrimaryKeys(start == null ? 0 : start, rows == null ? 10 : rows));
    }

    public boolean deleteRow(String tableName, String key) throws IOException {
        return this.rwl.readEx(() -> this.getTable(tableName).deleteRow(key));
    }

    public TableRequestResult query(String tableName, TableRequest request) throws IOException {
        return this.rwl.readEx(() -> {
            LinkedHashMap<String, Map<String, CollectorInterface.LongCounter>> counters;
            long start = request.start == null ? 0L : (long)request.start.intValue();
            long rows = request.rows == null ? Long.MAX_VALUE : (long)request.rows.intValue();
            Table table = this.getTable(tableName);
            if (request.counters != null && !request.counters.isEmpty()) {
                counters = new LinkedHashMap<String, Map<String, CollectorInterface.LongCounter>>();
                request.counters.forEach(col -> {
                    Map cfr_ignored_0 = counters.put((String)col, new HashMap());
                });
            } else {
                counters = null;
            }
            Query query = request.query == null ? null : Query.prepare(request.query, null);
            RoaringBitmap docBitset = table.query((Query)query, counters).finalBitmap;
            if (docBitset == null || docBitset.isEmpty()) {
                return new TableRequestResult(0L);
            }
            long count = docBitset.getCardinality();
            TableRequestResult result = new TableRequestResult(count);
            table.getRows(docBitset, request.columns, start, rows, result.rows);
            if (counters == null) {
                return result;
            }
            counters.forEach((countersEntryKey, countersEntry) -> {
                LinkedHashMap counter = new LinkedHashMap();
                countersEntry.forEach((key, counterEntry) -> counter.put(key, counterEntry.count));
                result.counters.put((String)countersEntryKey, counter);
            });
            return result;
        });
    }
}

