/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database;

import com.qwazr.cluster.ClusterManager;
import com.qwazr.database.TableManager;
import com.qwazr.database.TableServiceBuilder;
import com.qwazr.server.BaseServer;
import com.qwazr.server.GenericServer;
import com.qwazr.server.WelcomeShutdownService;
import com.qwazr.server.configuration.ServerConfiguration;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.management.MBeanException;
import javax.management.OperationsException;
import javax.servlet.ServletException;

public class TableServer
implements BaseServer {
    private final GenericServer server;
    private final TableManager tableManager;
    private final ClusterManager clusterManager;
    private final TableServiceBuilder serviceBuilder;
    private static volatile TableServer INSTANCE;

    public TableServer(ServerConfiguration serverConfiguration) throws IOException, URISyntaxException {
        GenericServer.Builder builder = GenericServer.of(serverConfiguration, null).webService(WelcomeShutdownService.class);
        this.clusterManager = new ClusterManager(builder);
        this.tableManager = TableManager.getNewInstance(builder);
        this.serviceBuilder = new TableServiceBuilder(this.clusterManager, this.tableManager);
        this.server = builder.build();
    }

    public TableServiceBuilder getServiceBuilder() {
        return this.serviceBuilder;
    }

    @Override
    public GenericServer getServer() {
        return this.server;
    }

    public static synchronized TableServer getInstance() {
        return INSTANCE;
    }

    public static synchronized void main(String ... args) throws IOException, ReflectiveOperationException, OperationsException, ServletException, MBeanException, URISyntaxException, InterruptedException {
        if (INSTANCE != null) {
            TableServer.shutdown();
        }
        INSTANCE = new TableServer(new ServerConfiguration(args));
        INSTANCE.start();
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            INSTANCE.stop();
        }
        INSTANCE = null;
    }
}

