/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.database.TableManager;
import com.qwazr.database.TableServiceInterface;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.model.TableDefinition;
import com.qwazr.database.model.TableRequest;
import com.qwazr.database.model.TableRequestResult;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.Query;
import com.qwazr.server.AbstractServiceImpl;
import com.qwazr.server.ServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableServiceImpl
extends AbstractServiceImpl
implements TableServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableServiceImpl.class);
    private TableManager tableManager;
    public static final TypeReference<Map<String, Object>> MapStringColumnValueTypeRef = new TypeReference<Map<String, Object>>(){};

    TableServiceImpl(TableManager tableManager) {
        this.tableManager = tableManager;
    }

    public TableServiceImpl() {
        this(null);
    }

    @PostConstruct
    public void init() {
        this.tableManager = this.getContextAttribute(TableManager.class);
    }

    @Override
    public Set<String> list() {
        return Collections.unmodifiableSet(this.tableManager.getNameSet());
    }

    @Override
    public TableDefinition createTable(String tableName, KeyStore.Impl storeImplementation) {
        try {
            if (storeImplementation == null) {
                storeImplementation = KeyStore.Impl.leveldb;
            }
            this.tableManager.createTable(tableName, storeImplementation);
            return new TableDefinition(storeImplementation, this.tableManager.getColumns(tableName));
        }
        catch (Exception e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public TableDefinition getTable(String tableName) {
        try {
            return new TableDefinition(null, this.tableManager.getColumns(tableName));
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public Boolean deleteTable(String tableName) {
        try {
            this.tableManager.deleteTable(tableName);
            return true;
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public Map<String, ColumnDefinition> getColumns(String tableName) {
        try {
            return this.tableManager.getColumns(tableName);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public ColumnDefinition getColumn(String tableName, String columnName) {
        try {
            return this.tableManager.getColumns(tableName).get(columnName);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public List<Object> getColumnTerms(String tableName, String columnName, Integer start, Integer rows) {
        try {
            return this.tableManager.getColumnTerms(tableName, columnName, start, rows);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public List<String> getColumnTermKeys(String tableName, String columnName, String term, Integer start, Integer rows) {
        try {
            return this.tableManager.getColumnTermKeys(tableName, columnName, term, start, rows);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public ColumnDefinition setColumn(String tableName, String columnName, ColumnDefinition columnDefinition) {
        try {
            this.tableManager.setColumn(tableName, columnName, columnDefinition);
            return columnDefinition;
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public Boolean removeColumn(String table_name, String column_name) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Long upsertRows(String table_name, List<Map<String, Object>> rows) {
        try {
            return this.tableManager.upsertRows(table_name, rows);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Long upsertRows(String table_name, Integer bufferLength, InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, Object> upsertRow(String table_name, String row_id, Map<String, Object> node) {
        try {
            this.tableManager.upsertRow(table_name, row_id, node);
            return node;
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    public LinkedHashMap<String, Object> getRow(String table_name, String row_id, Set<String> columns) {
        try {
            return this.tableManager.getRow(table_name, row_id, columns);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public List<Map<String, Object>> getRows(String table_name, Set<String> columns, Set<String> row_ids) {
        try {
            return this.tableManager.getRows(table_name, columns, row_ids);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public List<String> getRows(String table_name, Integer start, Integer rows) {
        try {
            return this.tableManager.getPrimaryKeys(table_name, start, rows);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public Boolean deleteRow(String table_name, String row_id) {
        try {
            return this.tableManager.deleteRow(table_name, row_id);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    @Override
    public TableRequestResult queryRows(String table_name, TableRequest request) {
        try {
            return this.tableManager.query(table_name, request);
        }
        catch (Query.QueryException | ServerException | IOException e) {
            throw ServerException.getJsonException(LOGGER, e);
        }
    }

    private class BufferFlush {
        private final List<Map<String, Object>> buffer;
        private final String tableName;

        private BufferFlush(int bufferSize, String tableName) {
            this.buffer = new ArrayList<Map<String, Object>>(bufferSize);
            this.tableName = tableName;
        }

        private int addRow(Map<String, Object> row) {
            this.buffer.add(row);
            return this.buffer.size();
        }

        private int flush() throws IOException {
            if (this.buffer.size() == 0) {
                return 0;
            }
            int res = TableServiceImpl.this.tableManager.upsertRows(this.tableName, this.buffer);
            this.buffer.clear();
            return res;
        }

        static /* synthetic */ int access$200(BufferFlush x0, Map x1) {
            return x0.addRow(x1);
        }

        static /* synthetic */ int access$300(BufferFlush x0) throws IOException {
            return x0.flush();
        }
    }
}

