/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.model.TableDefinition;
import com.qwazr.database.model.TableRequest;
import com.qwazr.database.model.TableRequestResult;
import com.qwazr.database.store.KeyStore;
import com.qwazr.server.ServiceInterface;
import com.qwazr.server.ServiceName;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@RolesAllowed(value={"table"})
@Path(value="/table")
@ServiceName(value="table")
public interface TableServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "table";
    public static final TypeReference<Set<String>> SetStringTypeRef = new TypeReference<Set<String>>(){};
    public static final TypeReference<List<Object>> ListObjectTypeRef = new TypeReference<List<Object>>(){};
    public static final TypeReference<List<String>> ListStringTypeRef = new TypeReference<List<String>>(){};
    public static final TypeReference<Map<String, Object>> MapStringObjectTypeRef = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<List<Map<String, Object>>> ListMapStringObjectTypeRef = new TypeReference<List<Map<String, Object>>>(){};

    @GET
    @Path(value="/")
    @Produces(value={"application/json; charset=UTF-8"})
    public Set<String> list();

    @POST
    @Path(value="/{table_name}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public TableDefinition createTable(@PathParam(value="table_name") String var1, @QueryParam(value="implementation") KeyStore.Impl var2);

    @GET
    @Path(value="/{table_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public TableDefinition getTable(@PathParam(value="table_name") String var1);

    @DELETE
    @Path(value="/{table_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Boolean deleteTable(@PathParam(value="table_name") String var1);

    @GET
    @Path(value="/{table_name}/column")
    @Produces(value={"application/json; charset=UTF-8"})
    public Map<String, ColumnDefinition> getColumns(@PathParam(value="table_name") String var1);

    @GET
    @Path(value="/{table_name}/column/{column_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public ColumnDefinition getColumn(@PathParam(value="table_name") String var1, @PathParam(value="column_name") String var2);

    @GET
    @Path(value="/{table_name}/column/{column_name}/term")
    @Produces(value={"application/json; charset=UTF-8"})
    public List<Object> getColumnTerms(@PathParam(value="table_name") String var1, @PathParam(value="column_name") String var2, @QueryParam(value="start") Integer var3, @QueryParam(value="rows") Integer var4);

    @GET
    @Path(value="/{table_name}/column/{column_name}/term/{term}")
    @Produces(value={"application/json; charset=UTF-8"})
    public List<String> getColumnTermKeys(@PathParam(value="table_name") String var1, @PathParam(value="column_name") String var2, @PathParam(value="term") String var3, @QueryParam(value="start") Integer var4, @QueryParam(value="rows") Integer var5);

    @POST
    @Path(value="/{table_name}/column/{column_name}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public ColumnDefinition setColumn(@PathParam(value="table_name") String var1, @PathParam(value="column_name") String var2, ColumnDefinition var3);

    @DELETE
    @Path(value="/{table_name}/column/{column_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Boolean removeColumn(@PathParam(value="table_name") String var1, @PathParam(value="column_name") String var2);

    @GET
    @Path(value="/{table_name}/row")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public List<String> getRows(@PathParam(value="table_name") String var1, @QueryParam(value="start") Integer var2, @QueryParam(value="rows") Integer var3);

    @POST
    @Path(value="/{table_name}/row")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Long upsertRows(@PathParam(value="table_name") String var1, List<Map<String, Object>> var2);

    @POST
    @Path(value="/{table_name}/row")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Long upsertRows(@PathParam(value="table_name") String var1, @QueryParam(value="buffer") Integer var2, InputStream var3);

    @PUT
    @Path(value="/{table_name}/row/{row_id}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Map<String, Object> upsertRow(@PathParam(value="table_name") String var1, @PathParam(value="row_id") String var2, Map<String, Object> var3);

    @GET
    @Path(value="/{table_name}/row/{row_id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Map<String, Object> getRow(@PathParam(value="table_name") String var1, @PathParam(value="row_id") String var2, @QueryParam(value="column") Set<String> var3);

    @POST
    @Path(value="/{table_name}/rows")
    @Produces(value={"application/json; charset=UTF-8"})
    public List<Map<String, Object>> getRows(@PathParam(value="table_name") String var1, @QueryParam(value="column") Set<String> var2, Set<String> var3);

    @DELETE
    @Path(value="/{table_name}/row/{row_id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Boolean deleteRow(@PathParam(value="table_name") String var1, @PathParam(value="row_id") String var2);

    @POST
    @Path(value="/{table_name}/query")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public TableRequestResult queryRows(@PathParam(value="table_name") String var1, TableRequest var2);
}

