/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database;

import com.qwazr.database.TableServiceInterface;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.model.TableDefinition;
import com.qwazr.database.model.TableRequest;
import com.qwazr.database.model.TableRequestResult;
import com.qwazr.database.store.KeyStore;
import com.qwazr.server.RemoteService;
import com.qwazr.server.client.JsonClientAbstract;
import com.qwazr.utils.UBuilder;
import com.qwazr.utils.http.HttpRequest;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;

class TableSingleClient
extends JsonClientAbstract
implements TableServiceInterface {
    TableSingleClient(RemoteService remote) {
        super(remote);
    }

    @Override
    public Set<String> list() {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table");
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return (Set)this.executeJson(request, null, null, SetStringTypeRef, valid200Json);
    }

    @Override
    public TableDefinition createTable(String tableName, KeyStore.Impl storeImplementation) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName).setParameter("implementation", storeImplementation);
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, TableDefinition.class, valid200Json);
    }

    @Override
    public TableDefinition getTable(String tableName) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, TableDefinition.class, valid200Json);
    }

    @Override
    public Boolean deleteTable(String tableName) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName);
        HttpRequest.Base<HttpDelete> request = HttpRequest.Delete(uriBuilder.buildNoEx());
        return this.executeStatusCode(request, null, null, valid200) == 200;
    }

    @Override
    public Map<String, ColumnDefinition> getColumns(String tableName) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/column");
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, ColumnDefinition.MapStringColumnTypeRef, valid200Json);
    }

    @Override
    public ColumnDefinition getColumn(String tableName, String columnName) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/column/", columnName);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, ColumnDefinition.class, valid200204Json);
    }

    @Override
    public List<Object> getColumnTerms(String tableName, String columnName, Integer start, Integer rows) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/column/", columnName, "/term").setParameter("start", start).setParameter("rows", rows);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return (List)this.executeJson(request, null, null, ListObjectTypeRef, valid200Json);
    }

    @Override
    public List<String> getColumnTermKeys(String tableName, String columnName, String term, Integer start, Integer rows) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/column/", columnName, "/term/", term).setParameter("start", start).setParameter("rows", rows);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return (List)this.executeJson(request, null, null, ListStringTypeRef, valid200Json);
    }

    @Override
    public ColumnDefinition setColumn(String tableName, String columnName, ColumnDefinition columnDefinition) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/column/", columnName);
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uriBuilder.buildNoEx());
        return this.executeJson(request, (Object)columnDefinition, null, ColumnDefinition.class, valid200Json);
    }

    @Override
    public Boolean removeColumn(String tableName, String columnName) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/column/", columnName);
        HttpRequest.Base<HttpDelete> request = HttpRequest.Delete(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, Boolean.class, valid200Json);
    }

    @Override
    public Long upsertRows(String tableName, List<Map<String, Object>> rows) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/row");
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uriBuilder.buildNoEx());
        return this.executeJson(request, rows, null, Long.class, valid200Json);
    }

    @Override
    public Long upsertRows(String tableName, Integer buffer, InputStream inputStream) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/row");
        uriBuilder.setParameter("buffer", buffer);
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uriBuilder.buildNoEx()).bodyStream(inputStream, ContentType.TEXT_PLAIN);
        return this.executeJson(request, null, null, Long.class, valid200Json);
    }

    @Override
    public Map<String, Object> upsertRow(String tableName, String rowId, Map<String, Object> row) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/row/", rowId);
        HttpRequest.Entity<HttpPut> request = HttpRequest.Put(uriBuilder.buildNoEx());
        return (Map)this.executeJson(request, row, null, MapStringObjectTypeRef, valid200Json);
    }

    @Override
    public Map<String, Object> getRow(String tableName, String rowId, Set<String> columns) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/row/", rowId);
        if (columns != null) {
            for (String column : columns) {
                uriBuilder.addParameter("column", column);
            }
        }
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return (Map)this.executeJson(request, null, null, MapStringObjectTypeRef, valid200Json);
    }

    @Override
    public List<Map<String, Object>> getRows(String tableName, Set<String> columns, Set<String> rowsIds) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/rows");
        if (columns != null) {
            for (String column : columns) {
                uriBuilder.addParameter("column", column);
            }
        }
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uriBuilder.buildNoEx());
        return (List)this.executeJson(request, rowsIds, null, ListMapStringObjectTypeRef, valid200Json);
    }

    @Override
    public List<String> getRows(String tableName, Integer start, Integer rows) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/row").setParameter("start", start).setParameter("rows", rows);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uriBuilder.buildNoEx());
        return (List)this.executeJson(request, null, null, ListStringTypeRef, valid200Json);
    }

    @Override
    public Boolean deleteRow(String tableName, String rowId) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/row/", rowId);
        HttpRequest.Base<HttpDelete> request = HttpRequest.Delete(uriBuilder.buildNoEx());
        return this.executeJson(request, null, null, Boolean.class, valid200Json);
    }

    @Override
    public TableRequestResult queryRows(String tableName, TableRequest tableRequest) {
        UBuilder uriBuilder = RemoteService.getNewUBuilder(this.remote, "/table/", tableName, "/query");
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uriBuilder.buildNoEx());
        return this.executeJson(request, (Object)tableRequest, null, TableRequestResult.class, valid200Json);
    }
}

