/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.annotations;

import com.qwazr.database.TableServiceInterface;
import com.qwazr.database.annotations.Table;
import com.qwazr.database.annotations.TableColumn;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.model.TableDefinition;
import com.qwazr.database.model.TableRequest;
import com.qwazr.database.model.TableRequestResult;
import com.qwazr.database.store.KeyStore;
import com.qwazr.utils.AnnotationsUtils;
import com.qwazr.utils.FieldMapWrapper;
import com.qwazr.utils.StringUtils;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AnnotatedTableService<T>
extends FieldMapWrapper<T> {
    protected final TableServiceInterface tableService;
    private final Class<T> tableDefinitionClass;
    protected final String tableName;
    private final Map<String, TableColumn> tableColumnMap;

    public AnnotatedTableService(TableServiceInterface tableService, Class<T> tableDefinitionClass, String tableName) throws URISyntaxException {
        super(new LinkedHashMap<String, Field>(), tableDefinitionClass);
        Objects.requireNonNull(tableService, "The tableService parameter is null");
        Objects.requireNonNull(tableDefinitionClass, "The tableDefinitionClass parameter is null");
        this.tableService = tableService;
        this.tableDefinitionClass = tableDefinitionClass;
        Table table = tableDefinitionClass.getAnnotation(Table.class);
        Objects.requireNonNull(table, "This class does not declare any Table annotation: " + tableDefinitionClass);
        this.tableName = tableName != null ? tableName : table.value();
        this.tableColumnMap = new LinkedHashMap<String, TableColumn>();
        AnnotationsUtils.browseFieldsRecursive(tableDefinitionClass, field -> {
            if (!field.isAnnotationPresent(TableColumn.class)) {
                return;
            }
            field.setAccessible(true);
            TableColumn tableColumn = field.getDeclaredAnnotation(TableColumn.class);
            String columnName = StringUtils.isEmpty(tableColumn.name()) ? field.getName() : tableColumn.name();
            this.tableColumnMap.put(columnName, tableColumn);
            this.fieldMap.put(columnName, field);
        });
    }

    public AnnotatedTableService(TableServiceInterface tableService, Class<T> tableDefinitionClass) throws URISyntaxException {
        this(tableService, tableDefinitionClass, null);
    }

    public String getTableName() {
        return this.tableName;
    }

    private final void checkParameters() {
        if (StringUtils.isEmpty(this.tableName)) {
            throw new RuntimeException("The table name is empty");
        }
    }

    public void createUpdateTable() {
        this.checkParameters();
        if (this.tableService.list().contains(this.tableName)) {
            return;
        }
        this.tableService.createTable(this.tableName, KeyStore.Impl.leveldb);
    }

    public TableDefinition getTable() {
        this.checkParameters();
        return this.tableService.getTable(this.tableName);
    }

    public void deleteTable() {
        this.checkParameters();
        this.tableService.deleteTable(this.tableName);
    }

    private LinkedHashMap<String, ColumnDefinition> getAnnotatedFields() {
        LinkedHashMap<String, ColumnDefinition> columnFields = new LinkedHashMap<String, ColumnDefinition>();
        if (this.tableColumnMap != null) {
            this.tableColumnMap.forEach((name, propertyField) -> columnFields.put((String)name, new ColumnDefinition((TableColumn)propertyField)));
        }
        return columnFields;
    }

    public void createUpdateFields() {
        this.checkParameters();
        this.getColumnChanges().forEach((columnName, fieldStatus) -> {
            switch (fieldStatus) {
                case NOT_IDENTICAL: {
                    this.tableService.removeColumn(this.tableName, (String)columnName);
                    this.tableService.setColumn(this.tableName, (String)columnName, new ColumnDefinition(this.tableColumnMap.get(columnName)));
                    break;
                }
                case EXISTS_ONLY_IN_ANNOTATION: {
                    this.tableService.setColumn(this.tableName, (String)columnName, new ColumnDefinition(this.tableColumnMap.get(columnName)));
                    break;
                }
                case EXISTS_ONLY_IN_TABLE: {
                    this.tableService.removeColumn(this.tableName, (String)columnName);
                    break;
                }
            }
        });
    }

    public Map<String, FieldStatus> getColumnChanges() {
        this.checkParameters();
        LinkedHashMap<String, ColumnDefinition> annotatedFields = this.getAnnotatedFields();
        Map<String, ColumnDefinition> tableColumns = this.tableService.getColumns(this.tableName);
        HashMap<String, FieldStatus> fieldChanges = new HashMap<String, FieldStatus>();
        if (this.tableColumnMap != null) {
            this.tableColumnMap.forEach((name, propertyField) -> {
                ColumnDefinition tableColumn;
                ColumnDefinition annotatedField = (ColumnDefinition)annotatedFields.get(name);
                ColumnDefinition columnDefinition = tableColumn = tableColumns == null ? null : (ColumnDefinition)tableColumns.get(name);
                if (tableColumn == null) {
                    if (!name.equals("$id$")) {
                        fieldChanges.put((String)name, FieldStatus.EXISTS_ONLY_IN_ANNOTATION);
                    }
                } else if (!Objects.equals((Object)tableColumn.mode, (Object)annotatedField.mode) || !Objects.equals((Object)tableColumn.type, (Object)annotatedField.type)) {
                    fieldChanges.put((String)name, FieldStatus.NOT_IDENTICAL);
                }
            });
        }
        if (tableColumns != null) {
            tableColumns.forEach((name, tableColumn) -> {
                if (!annotatedFields.containsKey(name)) {
                    fieldChanges.put((String)name, FieldStatus.EXISTS_ONLY_IN_TABLE);
                }
            });
        }
        return fieldChanges;
    }

    public ColumnDefinition getColumn(String columnName) {
        this.checkParameters();
        return this.tableService.getColumn(this.tableName, columnName);
    }

    public Map<String, ColumnDefinition> getColumns() {
        this.checkParameters();
        return this.tableService.getColumns(this.tableName);
    }

    public List<Object> getColumnTerms(String columnName, Integer start, Integer rows) {
        this.checkParameters();
        return this.tableService.getColumnTerms(this.tableName, columnName, start, rows);
    }

    public List<String> getColumnTermKeys(String columnName, String term, Integer start, Integer rows) {
        this.checkParameters();
        return this.tableService.getColumnTermKeys(this.tableName, columnName, term, start, rows);
    }

    public List<String> getRows(Integer start, Integer rows) {
        this.checkParameters();
        return this.tableService.getRows(this.tableName, start, rows);
    }

    public List<T> getRows(Set<String> columns, Set<String> rowIds) {
        this.checkParameters();
        return this.toRecords(this.tableService.getRows(this.tableName, columns, rowIds));
    }

    public Long upsertRows(List<T> rows) {
        this.checkParameters();
        return this.tableService.upsertRows(this.tableName, this.newMapCollection(rows));
    }

    public void upsertRow(String rowId, T row) {
        this.checkParameters();
        this.tableService.upsertRow(this.tableName, rowId, this.newMap(row));
    }

    public T getRow(String rowId, Set<String> columns) throws ReflectiveOperationException {
        this.checkParameters();
        return this.toRecord(this.tableService.getRow(this.tableName, rowId, columns));
    }

    public Boolean deleteRow(String rowId) {
        this.checkParameters();
        return this.tableService.deleteRow(this.tableName, rowId);
    }

    public TableRequestResultRecords<T> queryRows(TableRequest tableRequest) {
        this.checkParameters();
        TableRequestResult result = this.tableService.queryRows(this.tableName, tableRequest);
        return result == null ? null : new TableRequestResultRecords(result, this.toRecords(result.rows));
    }

    public static class TableRequestResultRecords<T>
    extends TableRequestResult {
        public final List<T> records;

        private TableRequestResultRecords(TableRequestResult result, List<T> records) {
            super(result);
            this.records = records;
        }
    }

    public static enum FieldStatus {
        NOT_IDENTICAL,
        EXISTS_ONLY_IN_TABLE,
        EXISTS_ONLY_IN_ANNOTATION;

    }
}

