/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.database.annotations.TableColumn;
import com.qwazr.utils.json.JsonMapper;
import java.io.IOException;
import java.util.Map;

public class ColumnDefinition {
    public final Type type;
    public final Mode mode;
    public static final TypeReference<Map<String, ColumnDefinition>> MapStringColumnTypeRef = new TypeReference<Map<String, ColumnDefinition>>(){};

    public ColumnDefinition() {
        this(null, null);
    }

    public ColumnDefinition(Type type, Mode mode) {
        this.type = type;
        this.mode = mode;
    }

    public ColumnDefinition(TableColumn propertyField) {
        this.type = propertyField.type();
        this.mode = propertyField.mode();
    }

    public ColumnDefinition(ColumnDefinition colDef) {
        if (colDef != null) {
            this.type = colDef.type;
            this.mode = colDef.mode;
        } else {
            this.type = null;
            this.mode = null;
        }
    }

    public static final ColumnDefinition newColumnDefinition(String jsonString) throws IOException {
        return JsonMapper.MAPPER.readValue(jsonString, ColumnDefinition.class);
    }

    public static class Internal
    extends ColumnDefinition {
        public final int column_id;
        public static final Internal PRIMARYKEY_COLUMN = new Internal();

        public Internal() {
            this(null, 0);
        }

        public Internal(ColumnDefinition colDef, int column_id) {
            super(colDef);
            this.column_id = column_id;
        }
    }

    public static enum Mode {
        INDEXED,
        STORED;

    }

    public static enum Type {
        STRING,
        DOUBLE,
        LONG,
        INTEGER;

    }
}

