/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.model;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.qwazr.utils.json.JsonMapper;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class TableQuery {
    protected abstract ObjectNode build();

    public static class And
    extends Group {
        public And() {
            super("$AND");
        }
    }

    public static class Or
    extends Group {
        public Or() {
            super("$OR");
        }
    }

    public static abstract class Group
    extends TableQuery {
        private final String command;
        private final Set<TableQuery> queries;

        protected Group(String command) {
            this.command = command;
            this.queries = new LinkedHashSet<TableQuery>();
        }

        public final Group add(String column, String term) {
            this.queries.add(new StringTerm(column, term));
            return this;
        }

        public final Group add(String column, Long term) {
            this.queries.add(new LongTerm(column, term));
            return this;
        }

        public final Group add(String column, Integer term) {
            this.queries.add(new IntegerTerm(column, term));
            return this;
        }

        public final Group add(String column, Double term) {
            this.queries.add(new DoubleTerm(column, term));
            return this;
        }

        public final Group add(String column, Float term) {
            this.queries.add(new FloatTerm(column, term));
            return this;
        }

        public final Group add(Group group) {
            this.queries.add(group);
            return this;
        }

        @Override
        public final ObjectNode build() {
            ArrayNode array = JsonMapper.MAPPER.createArrayNode();
            for (TableQuery q : this.queries) {
                array.add(q.build());
            }
            ObjectNode object = JsonMapper.MAPPER.createObjectNode();
            object.set(this.command, array);
            return object;
        }
    }

    private static class IntegerTerm
    extends Term<Integer> {
        private IntegerTerm(String column, Integer value) {
            super(column, value);
        }

        @Override
        protected final ObjectNode build() {
            return JsonMapper.MAPPER.createObjectNode().put(this.column, (Integer)this.value);
        }
    }

    private static class LongTerm
    extends Term<Long> {
        private LongTerm(String column, Long value) {
            super(column, value);
        }

        @Override
        protected final ObjectNode build() {
            return JsonMapper.MAPPER.createObjectNode().put(this.column, (Long)this.value);
        }
    }

    private static class FloatTerm
    extends Term<Float> {
        private FloatTerm(String column, Float value) {
            super(column, value);
        }

        @Override
        protected final ObjectNode build() {
            return JsonMapper.MAPPER.createObjectNode().put(this.column, (Float)this.value);
        }
    }

    private static class DoubleTerm
    extends Term<Double> {
        private DoubleTerm(String column, Double value) {
            super(column, value);
        }

        @Override
        protected final ObjectNode build() {
            return JsonMapper.MAPPER.createObjectNode().put(this.column, (Double)this.value);
        }
    }

    private static class StringTerm
    extends Term<String> {
        private StringTerm(String column, String value) {
            super(column, value);
        }

        @Override
        protected final ObjectNode build() {
            return JsonMapper.MAPPER.createObjectNode().put(this.column, (String)this.value);
        }
    }

    private static abstract class Term<T>
    extends TableQuery {
        protected final String column;
        protected final T value;

        private Term(String column, T value) {
            this.column = column;
            this.value = value;
        }
    }
}

