/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.database.store.ValueConsumer;
import com.qwazr.server.ServerException;
import com.qwazr.utils.CharsetUtils;
import com.qwazr.utils.SerializationUtils;
import com.qwazr.utils.json.JsonMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.xerial.snappy.Snappy;

public interface ByteConverter<T> {
    public T convert(Object var1) throws IOException;

    public byte[] toBytes(T var1) throws IOException;

    public T toValue(byte[] var1) throws IOException;

    default public T toValue(ByteBuffer byteBuffer) throws IOException {
        byte[] bytes = new byte[byteBuffer.remaining()];
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), bytes, 0, bytes.length);
        return this.toValue(bytes);
    }

    default public void forEach(T value, ValueConsumer consumer) {
        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Function not implemented");
    }

    default public void forFirst(T value, ValueConsumer consumer) {
        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Function not implemented");
    }

    public static class StringArrayByteConverter
    extends AbstractCastConvert<String[]> {
        public static final StringArrayByteConverter INSTANCE = new StringArrayByteConverter();
        private static final String[] emptyStringArray = new String[0];

        @Override
        public final byte[] toBytes(String[] stringArray) throws IOException {
            int l = 0;
            for (String s : stringArray) {
                l += s.length() + 1;
            }
            char[] chars = new char[l];
            CharBuffer buffer = CharBuffer.wrap(chars);
            for (String s : stringArray) {
                buffer.append(s);
                buffer.append('\u0000');
            }
            return Snappy.compress(chars);
        }

        @Override
        public final String[] toValue(byte[] compressedByteArray) throws IOException {
            if (compressedByteArray == null) {
                return null;
            }
            char[] chars = Snappy.uncompressCharArray(compressedByteArray);
            if (chars.length == 0) {
                return emptyStringArray;
            }
            ArrayList<String> array = new ArrayList<String>();
            int last = 0;
            int pos = 0;
            for (char c : chars) {
                if (c == '\u0000') {
                    array.add(new String(chars, last, pos - last));
                    last = pos + 1;
                }
                ++pos;
            }
            return array.toArray(new String[array.size()]);
        }

        @Override
        public final void forEach(String[] values, ValueConsumer consumer) {
            if (values == null) {
                return;
            }
            for (String value : values) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(String[] values, ValueConsumer consumer) {
            if (values == null || values.length == 0) {
                return;
            }
            consumer.consume(values[0]);
        }
    }

    public static class DoubleArrayByteConverter
    extends AbstractCastConvert<double[]> {
        public static final DoubleArrayByteConverter INSTANCE = new DoubleArrayByteConverter();

        @Override
        public final byte[] toBytes(double[] doubleArray) throws IOException {
            return Snappy.compress(doubleArray);
        }

        @Override
        public final double[] toValue(byte[] compressedByteArray) throws IOException {
            if (compressedByteArray == null) {
                return null;
            }
            return Snappy.uncompressDoubleArray(compressedByteArray);
        }

        @Override
        public final void forEach(double[] values, ValueConsumer consumer) {
            if (values == null) {
                return;
            }
            for (double value : values) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(double[] values, ValueConsumer consumer) {
            if (values == null || values.length == 0) {
                return;
            }
            consumer.consume(values[0]);
        }
    }

    public static class LongArrayByteConverter
    extends AbstractCastConvert<long[]> {
        public static final LongArrayByteConverter INSTANCE = new LongArrayByteConverter();

        @Override
        public final byte[] toBytes(long[] intArray) throws IOException {
            return Snappy.compress(intArray);
        }

        @Override
        public final long[] toValue(byte[] compressedByteArray) throws IOException {
            if (compressedByteArray == null) {
                return null;
            }
            return Snappy.uncompressLongArray(compressedByteArray);
        }

        @Override
        public final void forEach(long[] values, ValueConsumer consumer) {
            if (values == null) {
                return;
            }
            for (long value : values) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(long[] values, ValueConsumer consumer) {
            if (values == null || values.length == 0) {
                return;
            }
            consumer.consume(values[0]);
        }
    }

    public static class IntArrayByteConverter
    extends AbstractCastConvert<int[]> {
        public static final IntArrayByteConverter INSTANCE = new IntArrayByteConverter();

        @Override
        public final byte[] toBytes(int[] intArray) throws IOException {
            return Snappy.compress(intArray);
        }

        @Override
        public final int[] toValue(byte[] compressedByteArray) throws IOException {
            if (compressedByteArray == null) {
                return null;
            }
            return Snappy.uncompressIntArray(compressedByteArray);
        }

        @Override
        public final void forEach(int[] values, ValueConsumer consumer) {
            if (values == null) {
                return;
            }
            for (int value : values) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(int[] values, ValueConsumer consumer) {
            if (values == null || values.length == 0) {
                return;
            }
            consumer.consume(values[0]);
        }
    }

    public static final class SerializableByteConverter<T extends Serializable>
    extends AbstractCastConvert<T> {
        @Override
        public final byte[] toBytes(T value) throws IOException {
            return SerializationUtils.toDefaultBytes(value);
        }

        @Override
        public final T toValue(byte[] bytes) throws IOException {
            try {
                return SerializationUtils.fromDefaultBytes(bytes);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
    }

    public static final class JsonTypeByteConverter<T>
    extends AbstractCastConvert<T> {
        private final TypeReference<T> typeReference;

        public JsonTypeByteConverter(TypeReference<T> typeReference) {
            this.typeReference = typeReference;
        }

        @Override
        public final byte[] toBytes(Object value) throws JsonProcessingException {
            return JsonMapper.MAPPER.writeValueAsBytes(value);
        }

        @Override
        public final T toValue(byte[] bytes) throws IOException {
            return JsonMapper.MAPPER.readValue(bytes, this.typeReference);
        }
    }

    public static class JsonByteConverter<T>
    extends AbstractCastConvert<T> {
        private final Class<T> objectClass;

        public JsonByteConverter(Class<T> objectClass) {
            this.objectClass = objectClass;
        }

        @Override
        public final byte[] toBytes(T value) throws JsonProcessingException {
            return JsonMapper.MAPPER.writeValueAsBytes(value);
        }

        @Override
        public final T toValue(byte[] bytes) throws IOException {
            return JsonMapper.MAPPER.readValue(bytes, this.objectClass);
        }
    }

    public static abstract class AbstractCastConvert<T>
    implements ByteConverter<T> {
        @Override
        public final T convert(Object value) {
            return (T)value;
        }
    }

    public static class StringByteConverter
    implements ByteConverter<String> {
        public static final StringByteConverter INSTANCE = new StringByteConverter();

        @Override
        public final String convert(Object value) {
            return value instanceof String ? (String)value : value.toString();
        }

        @Override
        public final byte[] toBytes(String value) {
            return CharsetUtils.encodeUtf8(value.toString());
        }

        @Override
        public final String toValue(byte[] bytes) {
            return CharsetUtils.decodeUtf8(bytes);
        }

        @Override
        public final String toValue(ByteBuffer byteBuffer) throws IOException {
            return CharsetUtils.decodeUtf8(byteBuffer);
        }

        @Override
        public final void forEach(String value, ValueConsumer consumer) {
            if (value != null) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(String value, ValueConsumer consumer) {
            this.forEach(value, consumer);
        }
    }

    public static class DoubleByteConverter
    extends AbstractNumberConverter<Double> {
        public static final DoubleByteConverter INSTANCE = new DoubleByteConverter();

        @Override
        public final byte[] toBytes(Double value) {
            return ByteBuffer.allocate(8).putDouble(value).array();
        }

        @Override
        final Double fromString(String string) {
            return Double.parseDouble(string);
        }

        @Override
        final Double fromNumber(Number number) {
            return number.doubleValue();
        }

        @Override
        public final Double toValue(byte[] bytes) {
            return ByteBuffer.wrap(bytes).getDouble();
        }

        @Override
        public final Double toValue(ByteBuffer byteBuffer) {
            return byteBuffer.getDouble();
        }

        @Override
        public final void forEach(Double value, ValueConsumer consumer) {
            if (value != null) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(Double value, ValueConsumer consumer) {
            this.forEach(value, consumer);
        }
    }

    public static class LongByteConverter
    extends AbstractNumberConverter<Long> {
        public static final LongByteConverter INSTANCE = new LongByteConverter();

        @Override
        public final byte[] toBytes(Long value) {
            return ByteBuffer.allocate(8).putLong(value).array();
        }

        @Override
        final Long fromString(String string) {
            return Long.parseLong(string);
        }

        @Override
        final Long fromNumber(Number number) {
            return number.longValue();
        }

        @Override
        public final Long toValue(byte[] bytes) {
            return ByteBuffer.wrap(bytes).getLong();
        }

        @Override
        public final Long toValue(ByteBuffer byteBuffer) {
            return byteBuffer.getLong();
        }

        @Override
        public final void forEach(Long value, ValueConsumer consumer) {
            if (value != null) {
                consumer.consume(value);
            }
        }

        @Override
        public final void forFirst(Long value, ValueConsumer consumer) {
            this.forEach(value, consumer);
        }
    }

    public static class IntegerByteConverter
    extends AbstractNumberConverter<Integer> {
        public static final IntegerByteConverter INSTANCE = new IntegerByteConverter();

        @Override
        public final byte[] toBytes(Integer value) {
            return ByteBuffer.allocate(4).putInt(value).array();
        }

        @Override
        final Integer fromString(String string) {
            return Integer.parseInt(string);
        }

        @Override
        final Integer fromNumber(Number number) {
            return number.intValue();
        }

        @Override
        public final Integer toValue(byte[] bytes) {
            return ByteBuffer.wrap(bytes).getInt();
        }

        @Override
        public final Integer toValue(ByteBuffer byteBuffer) {
            return byteBuffer.getInt();
        }

        @Override
        public final void forEach(Integer value, ValueConsumer consumer) {
            if (value != null) {
                consumer.consume(value.intValue());
            }
        }

        @Override
        public final void forFirst(Integer value, ValueConsumer consumer) {
            this.forEach(value, consumer);
        }
    }

    public static abstract class AbstractNumberConverter<T extends Number>
    implements ByteConverter<T> {
        @Override
        public final T convert(Object value) throws IOException {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return this.fromNumber((Number)value);
            }
            if (value instanceof String) {
                try {
                    return this.fromString((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Cannot convert " + value.getClass() + " to a number");
        }

        abstract T fromNumber(Number var1) throws IOException;

        abstract T fromString(String var1) throws IOException;
    }
}

