/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.QueryContext;
import com.qwazr.database.store.ValueConsumer;
import com.qwazr.database.store.keys.ColumnStoreKey;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.roaringbitmap.RoaringBitmap;

public interface CollectorInterface {
    public static Collector build() {
        return new Collector(null);
    }

    public void collect(RoaringBitmap var1) throws IOException;

    public void collect(int var1) throws IOException;

    public int getCount();

    public DocumentsCollector documents(Collection<Integer> var1);

    public FacetsCollector facets(QueryContext var1, ColumnDefinition.Internal var2, Map<Object, LongCounter> var3);

    public ScoresCollector scores();

    public static class ScoresCollector
    extends CollectorAbstract {
        private ScoresCollector(CollectorInterface parent) {
            super(parent);
        }

        @Override
        public final void collect(int docId) throws IOException {
            this.parent.collect(docId);
        }
    }

    public static class FacetsCollector
    extends CollectorAbstract
    implements ValueConsumer {
        private final QueryContext context;
        private final ColumnDefinition.Internal columnDef;
        private final Map<Object, LongCounter> termCounter;

        private FacetsCollector(CollectorInterface parent, QueryContext context, ColumnDefinition.Internal columnDef, Map<Object, LongCounter> termCounter) {
            super(parent);
            this.context = context;
            this.columnDef = columnDef;
            this.termCounter = termCounter;
        }

        @Override
        public final void collect(int docId) throws IOException {
            this.parent.collect(docId);
            ColumnStoreKey.newInstance(this.columnDef, docId).forEach(this.context.store, this);
        }

        @Override
        public final void consume(double value) {
            LongCounter counter = this.termCounter.get(value);
            if (counter == null) {
                this.termCounter.put(value, new LongCounter());
            } else {
                ++counter.count;
            }
        }

        @Override
        public void consume(long value) {
            LongCounter counter = this.termCounter.get(value);
            if (counter == null) {
                this.termCounter.put(value, new LongCounter());
            } else {
                ++counter.count;
            }
        }

        @Override
        public void consume(float value) {
            LongCounter counter = this.termCounter.get(Float.valueOf(value));
            if (counter == null) {
                this.termCounter.put(Float.valueOf(value), new LongCounter());
            } else {
                ++counter.count;
            }
        }

        @Override
        public void consume(String value) {
            LongCounter counter = this.termCounter.get(value);
            if (counter == null) {
                this.termCounter.put(value, new LongCounter());
            } else {
                ++counter.count;
            }
        }
    }

    public static class LongCounter {
        public long count = 1L;
    }

    public static class DocumentsCollector
    extends CollectorAbstract {
        private final Collection<Integer> documentIds;

        private DocumentsCollector(CollectorInterface parent, Collection<Integer> documentIds) {
            super(parent);
            this.documentIds = documentIds;
        }

        @Override
        public final void collect(int docId) throws IOException {
            this.documentIds.add(docId);
            this.parent.collect(docId);
        }
    }

    public static class Collector
    extends CollectorAbstract {
        private int count = 0;

        private Collector(CollectorInterface parent) {
            super(parent);
        }

        @Override
        public void collect(int docId) {
            ++this.count;
        }

        @Override
        public final int getCount() {
            return this.count;
        }
    }

    public static abstract class CollectorAbstract
    implements CollectorInterface {
        protected final CollectorInterface parent;

        private CollectorAbstract(CollectorInterface parent) {
            this.parent = parent;
        }

        @Override
        public final DocumentsCollector documents(Collection<Integer> documentIds) {
            return new DocumentsCollector(this, documentIds);
        }

        @Override
        public final FacetsCollector facets(QueryContext context, ColumnDefinition.Internal columnDef, Map<Object, LongCounter> termCounter) {
            return new FacetsCollector(this, context, columnDef, termCounter);
        }

        @Override
        public final ScoresCollector scores() {
            return new ScoresCollector(this);
        }

        @Override
        public final void collect(RoaringBitmap bitmap) throws IOException {
            for (Integer docId : bitmap) {
                this.collect(docId);
            }
        }

        @Override
        public int getCount() {
            return this.parent.getCount();
        }
    }
}

