/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.qwazr.database.store.KeyIterator;
import com.qwazr.database.store.KeyStoreLevelDb;
import com.qwazr.database.store.KeyStoreLmdb;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public interface KeyStore
extends Closeable {
    public boolean exists();

    public void delete() throws IOException;

    public byte[] get(byte[] var1);

    public void put(byte[] var1, byte[] var2) throws IOException;

    public void delete(byte[] var1) throws IOException;

    public KeyIterator iterator(byte[] var1);

    public static enum Impl {
        leveldb(KeyStoreLevelDb.class, "storedb"),
        lmdb(KeyStoreLmdb.class, "lmdb");

        public final Class<? extends KeyStore> storeClass;
        public final String directoryName;

        private Impl(Class<? extends KeyStore> storeClass, String directoryName) {
            this.storeClass = storeClass;
            this.directoryName = directoryName;
        }

        public static final Impl detect(File directory) {
            if (!directory.exists()) {
                return null;
            }
            for (Impl impl : Impl.values()) {
                if (!new File(directory, impl.directoryName).exists()) continue;
                return impl;
            }
            return null;
        }
    }
}

