/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.qwazr.database.store.KeyIterator;
import com.qwazr.database.store.KeyStore;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyStoreLevelDb
implements KeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreLevelDb.class);
    private final DB db;
    private final File file;
    private static boolean MEMORY_POOL = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void checkMemoryPool() {
        Class<KeyStoreLevelDb> clazz = KeyStoreLevelDb.class;
        synchronized (KeyStoreLevelDb.class) {
            if (MEMORY_POOL) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            JniDBFactory.pushMemoryPool(524288);
            MEMORY_POOL = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void freeMemoryPool() {
        Class<KeyStoreLevelDb> clazz = KeyStoreLevelDb.class;
        synchronized (KeyStoreLevelDb.class) {
            if (!MEMORY_POOL) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            JniDBFactory.popMemoryPool();
            MEMORY_POOL = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public KeyStoreLevelDb(File file) throws IOException {
        KeyStoreLevelDb.checkMemoryPool();
        Options options = new Options();
        options.logger(LOGGER::info);
        this.file = file;
        options.createIfMissing(true);
        this.db = JniDBFactory.factory.open(file, options);
    }

    @Override
    public final void close() throws IOException {
        this.db.close();
    }

    @Override
    public final boolean exists() {
        return this.file.exists();
    }

    @Override
    public final void delete() throws IOException {
        Options options = new Options();
        JniDBFactory.factory.destroy(this.file, options);
    }

    @Override
    public final byte[] get(byte[] key) {
        return this.db.get(key);
    }

    @Override
    public final void put(byte[] key, byte[] value) {
        this.db.put(key, value);
    }

    @Override
    public final void delete(byte[] key) {
        this.db.delete(key);
    }

    @Override
    public final KeyIterator iterator(byte[] key) {
        return new KeyIteratorImpl(key);
    }

    private class KeyIteratorImpl
    implements KeyIterator {
        private final DBIterator iterator;

        private KeyIteratorImpl(byte[] key) {
            this.iterator = KeyStoreLevelDb.this.db.iterator();
            this.iterator.seek(key);
        }

        @Override
        public final void close() throws IOException {
            this.iterator.close();
        }

        @Override
        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public final Map.Entry<byte[], byte[]> next() {
            return (Map.Entry)this.iterator.next();
        }
    }
}

